;===============================================================================
;
; Description:      iTunes Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs iTunes
; Last Modified:    10/2/12
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "iTunes"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\iTunes\itunes.exe"
Else
	$AppBinFile = "C:\Program Files\itunes\itunes.exe"
EndIf

;The expected file version.
$AppBinFileVersion = "10.7.0.21"
;The installation source directory
If @OSArch == "X64" Then
	$SourceDir = "\\server\share\applications\itunes\x64"
Else
	$SourceDir = "\\server\share\applications\itunes\x32"
EndIf

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	;run installer
	If @OSArch == "X64" Then
		Run ( $TMPDIR & "\" & $AppName & "\" & "iTunes64Setup10.7.exe",@WindowsDir )
	Else
		Run ( $TMPDIR & "\" & $AppName & "\" & "iTunesSetup10.7.exe",@WindowsDir )
	EndIf
	
	AdlibRegister("_iTunesWindows")

	WinWait("iTunes","Welcome")
	ControlClick("iTunes","Welcome","&Next >")

	WinWait("iTunes","Installation")
	ControlCommand("iTunes","Installation","Button1","UnCheck","")
	ControlClick("iTunes","Installation","&Install")

	WinWait("iTunes","Congratulations")
	ControlCommand("iTunes","Congratulations","Button1","UnCheck","")
	ControlClick("iTunes","Congratulations","&Finish")
	
	AdlibUnRegister("_iTunesWindows")


	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func _iTunesWindows()
	If WinExists("iTunes","License") Then
		ControlClick("iTunes","License","I &accept")
		ControlClick("iTunes","License","&Next >")
	EndIf

EndFunc
