;===============================================================================
;
; Description:      WinShell 3.3 Installer
; Syntax:           WinShell_3.3.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Josh Morris
; Note(s):          This script installs WinSehll
; Last Modified:    3/19/09
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

AutoItSetOption("TrayIconDebug",1)
AutoItSetOption ( "MouseCoordMode", 0 ) 

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "WinShell"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\WinShell\WinShell.exe"
;The expected file version.
$AppBinFileVersion = "3.3.0.3"
;The installation source directory
$SourceDir = "\\server\share\applications\winshell"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ( $TMPDIR & "\" & $AppName & "\" & "WinShell330.exe",@WindowsDir )

	WinWait("Setup","Welcome to the WinShell")
	ControlClick("Setup","Welcome to the WinShell","&Next >")
	
	WinWait("Setup","License")
	ControlClick("Setup","License","I &accept the agreement")
	ControlClick("Setup","License","&Next >")
	
	WinWait("Setup","Select Destination")
	ControlClick("Setup","Select Destination","&Next >")
	
	WinWait("Setup","Select Start Menu")
	ControlClick("Setup","Select Start Menu", "&Next >")
	
	WinWait("Setup","Select Additional")
	MouseClick($primary,51,163,1)
	;ControlCommand("Setup","Select Additional","TNewCheckListBox1","UnCheck","")
	ControlClick("Setup","Select Additional","&Next >")
	
	WinWait("Setup","Completing")
	MouseClick($primary,189,167,1)
	;ControlCommand("Setup","Completing","TNewCheckListBox1","UnCheck","")
	ControlClick("Setup","Completing","&Finish")
	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf
