;===============================================================================
;
; Description:      Save As PDF plugin for Microsoft Office 2007 Installer
; Syntax:           SaveAsPDF.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs the SaveAsPDFandXPS plugin Office 2007
;                   Have not actually found a file this installs so it checks if Excell version 12 is installed
; Last Modified:    7/10/08
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "SaveAsPDF"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Office\Office12\EXCEL.exe"
;The expected file version.
$AppBinFileVersion = "12.0.4518.1014"
;The installation source directory
$SourceDir = "\\server\share\applications\microsoft office 2007 addons"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

;check that at least minimum version of Office 2007 installed.
If $CurrentVer >= $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ( $TMPDIR & "\" & $AppName & "\" & "SaveAsPDFandXPS.exe",@WindowsDir )
		
	WinWait("Microsoft Save as PDF or XPS Add-in for 2007 Microsoft Office programs","You must accept")
	Sleep(300)
	Send("!a")
	Send("!c")
	
	WinWait("Microsoft Save as PDF or XPS Add-in for 2007 Microsoft Office programs","The installation is complete.")
	ControlClick("Microsoft Save as PDF or XPS Add-in for 2007 Microsoft Office programs","The installation is complete.","OK")
					
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

