;===============================================================================
;
; Description:      R for Windows Uninstaller
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script uninstalls older versions of R for Windows.
; Last Modified:    12/1/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"
#include "include\array.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "R"

; inform user of the versions being removed
MsgBox(0,"Uninstalling R","Versions lower than 2.14 will be removed",2)
_FileWriteLog($LogFile,"Search for old versions of R")

; initialize string for printing out which versions are taken 
$InstalledVersions = ""

; Check for the existence of the following versions of R
Local $versions[8] = ["R-2.13.2","R-2.13.1","R-2.13.0","R-2.12.1","R-2.12.1","R-2.11.0","R-2.10.1","R-2.10.0"]
$size = UBound($versions)

; Loop through each element & check if uninstaller exists, if so call it with RemoveR function
While($size > 0) 
	If FileExists("C:\Program Files\R\" & $versions[$size-1] & "\unins000.exe") Then
		$InstalledVersions = $InstalledVersions & " " & $versions[$size-1]
		_RemoveR($versions[$size-1])
	EndIf
	; decrement array and get new size
	_ArrayPop($versions)
	$size = UBound($versions)
WEnd

; Print the versions that were uninstalled
MsgBox(0,"Uninstalling R","Removed versions " & $InstalledVersions,5)

; Given a version number, run the uninstaller for that version
Func _RemoveR($version)
	
	Run ("C:\Program Files\R\" & $version & "\unins000.exe")
	
	WinWait("R","Are you sure you want to") 
	ControlClick("R","Are you sure you want to","&Yes")
	
	$versionshort = StringRight($version,6) ;e.g. 12.11.0
	
	WinWait("R","R for Windows " & $versionshort & " was successfully removed")
	ControlClick("R","R for Windows " & $versionshort & " was successfully removed","OK")


EndFunc





