;===============================================================================
;
; Description:      R for Windows Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs R for Windows and the 'UsingR' and 'foreign' packages. It sets the CRAN mirror to MTU and updates installed packages.
;					If the current version is found, it updates installed packages.
; Last Modified:    11/30/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "R"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files\R\R-2.14.0\bin\x64\R.exe"
	$AppEtcLocation = "C:\Program Files\R\R-2.14.0\etc\"
	$AppBinLocation = "C:\Program Files\R\R-2.14.0\bin\"
Else
	$AppBinFile = "C:\Program Files\R\R-2.14.0\bin\R.exe"
	$AppEtcLocation = "C:\Program Files\R\R-2.14.0\etc\"
	$AppBinLocation = "C:\Program Files\R\R-2.14.0\bin\"
EndIf
;The expected file version.
$AppBinFileVersion = "2.140.57496.0"
;The installation source directory
$SourceDir = "\\server\share\applications\r"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	;run installer
	Run ( $TMPDIR & "\" & $AppName & "\" & "R-2.14.0-win.exe",@WindowsDir )

	WinWait("Select Setup Language","Select the language to use")
	ControlClick("Select Setup Language","Select the language to use","OK")

	WinWait("Setup - R for Windows","Welcome to the R for Windows")
	ControlClick("Setup - R for Windows","Welcome to the R for Windows","&Next >")

	WinWait("Setup - R for Windows","Information")
	ControlClick("Setup - R for Windows","Information","&Next >")

	WinWait("Setup - R for Windows","Select Destination Location")
	ControlClick("Setup - R for Windows","Select Destination Location","&Next >")

	WinWait("Setup - R for Windows","Select Components")
	ControlClick("Setup - R for Windows","Select Components","&Next >")

	WinWait("Setup - R for Windows","Startup options")
	ControlClick("Setup - R for Windows","Startup options","&Next >")

	WinWait("Setup - R for Windows","Select Start Menu Folder")
	ControlClick("Setup - R for Windows","Select Start Menu Folder","&Next >")

	WinWait("Setup - R for Windows","Select Additional Tasks")
	ControlClick("Setup - R for Windows","Select Additional Tasks","&Next >")

	WinWait("Setup - R for Windows","&Finish")
	ControlClick("Setup - R for Windows","&Finish","&Finish")

	;copy Rprofile.site with the CRAN mirror location set
	FileCopy($TMPDIR & "\" & $AppName & "\" & "Rprofile.site",$AppEtcLocation,1)

	;run the R file to install packages
	$updatepid = Run(@ComSpec & " /c R CMD BATCH " & $TMPDIR & "\" & $AppName & "\" & "InstallPackages.R",$AppBinLocation)

	;wait while process runs
	ProcessWaitClose($updatepid)

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
	
	;update packages
	;run the R file to install packages
	$updatepid = Run(@ComSpec & " /c R CMD BATCH " & $TMPDIR & "\" & $AppName & "\" & "InstallPackages.R",$AppBinLocation)
	
EndIf

