;===============================================================================
;
; Description:      Quicktime Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs Apple Quicktime
; Last Modified:    12/20/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Quicktime"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\quicktime\quicktimeplayer.exe"
Else
	$AppBinFile = "C:\Program Files\quicktime\quicktimeplayer.exe"
EndIf
;The expected file version.
$AppBinFileVersion = "7.71.80.42"
;The installation source directory
$SourceDir = "\\server\share\applications\Quicktime\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "QuickTimeInstaller771.exe",@WindowsDir )

	WinWait("QuickTime for Windows","Welcome to the QuickTime 7 Installer")
	ControlClick("QuickTime for Windows","Welcome to the QuickTime 7 Installer","&Next >")

	WinWait("QuickTime for Windows","License Agreement")
	ControlClick("QuickTime for Windows","License Agreement","&Yes")

	WinWait("QuickTime for Windows","Destination Folder")
	ControlCommand("QuickTime for Windows","Destination Folder","Button2","UnCheck","");
	ControlClick("QuickTime for Windows","Destination Folder","&Install")

	WinWait("QuickTime for Windows","QuickTime Installer Completed")
	ControlClick("QuickTime for Windows","QuickTime Installer Completed","&Finish")

	WinWait("QuickTime for Windows","No Thanks")
	ControlClick("QuickTime for Windows","No Thanks","No Thanks")

	Sleep (3000)

	;Delete all Quicktime desktop shortcuts
    If @OSVersion == "WIN_VISTA" Then
		FileDelete("C:\Users\Public\Desktop\Quicktime Player.lnk")
	Else
		FileDelete ( $ALLUSERSPROFILE & "\Desktop\Quicktime Player.lnk" )
	EndIf

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

