;===============================================================================
;
; Description:      Paint.NET Installer
; Syntax:           PaintDoNet.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs Paint.NET 
; Last Modified:    10/13/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "PaintDotNet"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Paint.NET\PaintDotNet.exe"
Else
	$AppBinFile = "C:\Program Files\Paint.NET\PaintDotNet.exe"
EndIf

;The expected file version.
$AppBinFileVersion = "3.510.4297.28970"
;The installation source directory
$SourceDir = "\\server\share\applications\paintdotnet"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "Paint.NET.3.5.10.exe",@WindowsDir )

	; check if .NET Framework 2.0 installed
	AdlibRegister("_NoDotNet")

	WinWait("Paint.NET","This installer will help you")
	ControlClick("Paint.NET","This installer will help you","&Next >")

	AdlibUnRegister()

	WinWait("Paint.NET","Please take a moment")
	ControlClick("Paint.NET","Please take a moment","I &Agree")
	ControlClick("Paint.NET","Please take a moment", "&Next >")

	WinWait("Paint.NET","Paint.NET was installed")
	ControlClick("Paint.NET","Paint.NET was installed","Finish")

	WinWait("Untitled","",5)
	WinClose("Untitled")

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func _NoDotNet()
	If WinExists("Paint.NET","[English] Paint.NET requires that the .NET Framework") Then
	  ControlClick("Paint.NET","[English] Paint.NET requires that the .NET Framework","Cancel")

	  ;launch .NET 2.0 installer script
	   Run("\\server\share\autoit\autoit3.exe \\server\share\autoit\scripts\dotnet2.0.au3")

	   ;check for when .NET 2.0 installation is finished
	   WinWait("Microsoft .NET Framework 2.0 Setup","Setup Complete")
	   Sleep(1000)

	   ;relaunch paint.net install
	   Run ( $TMPDIR & "\" & $AppName & "\" & "Paint.NET.3.5.10.exe",@WindowsDir )
	EndIf

EndFunc

