;===============================================================================
;
; Description:      Compatilbility Pack for the 2007 Office System Installer 
; Syntax:           Office2003FileConverter.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs the FileFormatConverters.exe plugin for Office 2003. This plugin allows
;		    Office 2003 to open the new Word, Excel, and Powerpoint file formats (.docx, .xlsx, .pptx)
; Last Modified:    3/14/07
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Office2003FileConverter"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Office\Office12\excelcnv.exe"
;The expected file version.
$AppBinFileVersion = "12.0.4518.1014"
;The installation source directory
$SourceDir = "\\server\share\software patches\Microsoft Office 2003 File Converter"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ( $TMPDIR & "\" & $AppName & "\" & "FileFormatConverters.exe",@WindowsDir )
		
	WinWait("Compatibility Pack for the 2007 Office system","You must accept")
	ControlCommand("Compatibility Pack for the 2007 Office system","You must accept", "Button1","")
	ControlClick("Compatibility Pack for the 2007 Office system","You must accept","&Continue")
	
	WinWait("Compatibility Pack for the 2007 Office system","The installation is complete.")
	ControlClick("Compatibility Pack for the 2007 Office system","The installation is complete.","OK")
					
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

