;===============================================================================
;
; Description:      ODF Add-in for Microsoft Word 
; Syntax:           ODFAddin.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs the ODF Add-in plugin for Office 2007. This plugin allows
;		    Word to open ODF files by converting them to xml. It can be used with Office 2003
;		    as long as the Compatibility Pack for 2007 files is also installed.
;
;                   This script is dependent on DotNet2.0.au3 if .NET 2.0 is not installed.
; Last Modified:    6/15/07
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "ODFAddin"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Clever Age\ODF Add-in for Microsoft Word\OdfConverterLauncher.exe"
;The expected file version.
$AppBinFileVersion = "1.0.0.0"
;The installation source directory
$SourceDir = "\\server\share\applications\Microsoft Office 2007 Addons"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ( $TMPDIR & "\" & $AppName & "\" & "Odf-AddInForWordSetup-en-1.0.exe",@WindowsDir )
		
	; check if .NET Framework 2.0 installed
	AdlibEnable("_NoDotNet")
	
	WinWait("ODF Add-in for Microsoft Word","The installer will guide")
	ControlClick("ODF Add-in for Microsoft Word","The installer will guide","&Next >")
	
	AdlibDisable()
	
	WinWait("ODF Add-in for Microsoft Word","Choose Word Add-in to install")
	ControlClick("ODF Add-in for Microsoft Word","Choose Word Add-in to install", "&Next >")
	
	WinWait("ODF Add-in for Microsoft Word","Select the language")
	ControlClick("ODF Add-in for Microsoft Word","Select the language","&Next >")
	
	WinWait("ODF Add-in for Microsoft Word","The installer will install ODF")
	ControlClick("ODF Add-in for Microsoft Word","The installer will install ODF", "&Next >")
	
	WinWait("ODF Add-in for Microsoft Word","Confirm Installation")
	ControlClick("ODF Add-in for Microsoft Word","Confirm Installation","&Next >")
	
	WinWait("ODF Add-in for Microsoft Word","Installation Complete")
	ControlClick("ODF Add-in for Microsoft Word","Installation Complete","&Close")
	
	Sleep(500)
	
	;change option to match title substring
	Opt("WinTitleMatchMode", 2)
	
	WinWait("ODF Add-in for Microsoft Word")
	WinClose("ODF Add-in for Microsoft Word")
					
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func _NoDotNet()
	If WinExists("ODF Add-in for Microsoft Word","This setup requires the .NET") Then
		  ControlClick("ODF Add-in for Microsoft Word","This setup requires the .NET","&No")
		  
		  ;Run the .NET 2.0 installation script
		  
		  Run("cmd")
		  WinWait("C:\WINDOWS\system32\cmd.exe")
		  Sleep(200)
		  Send("\\server\share\autoit\autoit3.exe \\server\share\autoit\scripts\DotNet2.0.au3{ENTER}")
		  Sleep(3000)
		  WinClose("C:\WINDOWS\system32\cmd.exe")
		  
		  WinWait("Microsoft .NET Framework 2.0 Setup","Welcome to Microsoft .NET")
		  
		  ;Wait for .NET process to close
		  ProcessWaitClose("dotnetfx.exe")
		  
		  ;Re-run ODF Add-in exe to finish ODF installation
		  Run ( $TMPDIR & "\" & $AppName & "\" & "Odf-AddInForWordSetup-en-1.0.exe",@WindowsDir )
		  
	EndIf
	
EndFunc