;===============================================================================
;
; Description:      MikTeX Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs MikTeX
; Last Modified:    7/13/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "MikTeX"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\MiKTeX 2.9\miktex\bin\mo.exe"
Else
	$AppBinFile = "C:\Program Files\MiKTeX 2.9\miktex\bin\mo.exe"
EndIf

;The expected file version.
$AppBinFileVersion = "2.9.3964.0"
;The installation source directory
$SourceDir = "\\server\share\applications\miktex 2.9"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "basic-miktex-2.9.4146.exe",@WindowsDir )

	AutoItSetOption ( "MouseCoordMode", 0 )

	WinWait("Basic MiKTeX","I &accept the")
	ControlCommand("Basic MiKTeX","I &accept the","Button1","Check")
	MouseClick($primary, 366, 369, 1, 0)

	WinWait("Basic MiKTeX","Install MiKTeX for")
	MouseClick($primary, 366, 369, 1, 0)

	WinWait("Basic MiKTeX","&Browse...")
	MouseClick($primary, 366, 369, 1, 0)

	WinWait("Basic MiKTeX","Preferred &paper")
	ControlCommand("Basic MiKTeX","Preferred &paper","Select String","Letter")
	MouseClick($primary, 366, 369, 1, 0)

	WinWait("Basic MiKTeX","MiKTeX Setup Wizard has enough information")
	MouseClick($primary, 366, 369, 1, 0)

	While WinExists("Basic MiKTeX","Installing:")
		Sleep(2000)
		MouseClick($primary, 366, 369, 1, 0)
	WEnd

	WinWait("Basic MiKTeX", "You have sucessfully completed")
	ControlClick("Basic MiKTeX","You have sucessfully complete","Close")

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

