;===============================================================================
;
; Description:      Office 2010 SP1
; Syntax:           
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs Office 2010 SP1
; Last Modified:    7/11/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "MS Office 2010 SP1"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Microsoft Office\Office14\EXCEL.EXE"
Else
	$AppBinFile = "C:\Program Files\Microsoft Office\Office14\EXCEL.EXE"
EndIf

;The expected file version.
$AppBinFileVersion = "14.0.6024.1000"
;The installation source directory
$SourceDir = "\\server\share\applications\Microsoft Office 2010 SP1\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	;run the installer
	Run ( $TMPDIR & "\" & $AppName & "\" & "officesuite2010sp1-kb2460049-x86-fullfile-en-us.exe",@WindowsDir )

	WinWait ( "Microsoft Office","You must accept" )
	ControlCommand("Microsoft Office", "You must accept","button1","Check","")
	ControlClick ( "Microsoft Office", "You must accept", "&Continue" )
		
	$done = 0
	While $done == 0
		If WinExists ("Microsoft Office","Do you want to reboot") Then
			ControlClick ("Microsoft Office","Do you want to reboot", "&No")
			$done = 1
		EndIf
		
		If WinExists("Microsoft Office","The installation is complete") Then
			ControlClick("Microsoft Office","The installation is complete","OK")
			$done = 1
		EndIf
	WEnd

	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf


