;===============================================================================
;
; Description:      Microsoft Office 2010 Pro Plus Installer
; Syntax:           Microsoft_Office_2010.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs Microsoft Office 2010 Professional
;                   Office 2010 now activates by KMS
; Last Modified:    5/28/10
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "MicrosoftOffice2010"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Microsoft Office\Office14\EXCEL.EXE"
Else
	$AppBinFile = "C:\Program Files\Microsoft Office\Office14\EXCEL.EXE"
EndIf

;The expected file version.
$AppBinFileVersion = "14.0.4756.1000"
;The installation source directory
$SourceDir = "\\server\share\applications\microsoft office 2010"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ($TMPDIR & "\" & $AppName & "\" & "setup.exe /config ""\\server\share\applications\microsoft office 2010\proplus.ww\config.xml"" /adminfile ""\\server\share\applications\microsoft office 2010\Office_2010_polisci.msp""",@WindowsDir )

	;wait for silent install
	WinWait("Microsoft Office Professional Plus")
	While WinExists("Microsoft Office Professional Plus")
		Sleep(5000)
		WinActivate("Microsoft Office Professional Plus")
		Send("!c")
	WEnd

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

