;===============================================================================
;
; Description:      Microsoft Office 2007 Pro SP2 Installer
; Syntax:           Microsoft_Office_2007_SP2.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs Microsoft Office 2007 Professional Service Pack 2
; Last Modified:    5/15/09
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Microsoft Office 2007 SP2"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Office\Office12\EXCEL.EXE"
;The expected file version.
$AppBinFileVersion = "12.0.6425.1000"
;The installation source directory
$SourceDir = "\\server\share\applications\microsoft office 2007 sp2"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)
	
	Run ($TMPDIR & "\" & $AppName & "\" & "office2007sp2-kb953195-fullfile-en-us.exe",@WindowsDir )
	
	WinWait("2007 Microsoft Office","You must accept the Microsoft")
	ControlCommand("2007 Microsoft Office","You must accept the Microsoft","Button1","Check","")
	ControlClick("2007 Microsoft Office","You must accept the Microsoft","&Continue")
	
	While ProcessExists("office2007sp2-kb953195-fullfile-en-us.exe")
		Sleep(1000)
	
		If WinExists("2007 Microsoft Office","Do you want to reboot") Then
			ControlClick("2007 Microsoft Office","Do you want to reboot","&No")
		EndIf
	
		If WinExists("2007 Microsoft Office","The installation is complete") Then
			ControlClick("2007 Microsoft Office","The installation is complete","OK")
		EndIf
	WEnd
	
	
		
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

