;===============================================================================
;
; Description:      Microsoft Office 2007 Pro Installer
; Syntax:           Microsoft_Office_2007.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs Microsoft Office 2007 Professional
;                   It includes our license key, so it should not be distributed
; Last Modified:    5/7/09
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "MicrosoftOffice2007"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Office\Office12\EXCEL.EXE"
;The expected file version.
$AppBinFileVersion = "12.0.4518.1014"
;The installation source directory
$SourceDir = "\\server\share\applications\microsoft office 2007"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)
	
	Run ($TMPDIR & "\" & $AppName & "\" & "setup.exe /adminfile ""\\server\share\applications\microsoft office 2007\Microsoft_Office_2007.msp""",@WindowsDir )
	
	;progress window
	WinWait("Microsoft Office Enterprise 2007")
	While WinExists("Microsoft Office Enterprise 2007")
		Sleep(1000)
	Wend
				
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

