;===============================================================================
;
; Description:      Microsoft Office 2003 SP3 Installer
; Syntax:           Microsoft_Office_2003_SP3.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs Microsoft Office 2003 Professional SP3
; Last Modified:    10/12/07
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "MicrosoftOffice2003 SP3"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Office\OFFICE11\EXCEL.EXE"
;The expected file version.
$AppBinFileVersion = "11.0.8169.0"
;The installation source directory
$SourceDir = "\\server\share\applications\microsoft office 2003 sp3"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ($TMPDIR & "\" & $AppName & "\" & "Office2003SP3-KB923618-FullFile-ENU.exe",@WindowsDir )
	
	WinWait("Office 2003 Service Pack 3 (SP3)","Do you want to install this update?")
	ControlClick("Office 2003 Service Pack 3 (SP3)","Do you want to install this update?","&Yes")
	
	WinWait("Office 2003 Service Pack 3 (SP3)","Please read the following")
	ControlClick("Office 2003 Service Pack 3 (SP3)","Please read the following","&Yes")
	
	WinWait("Office 2003 Service Pack 3 (SP3)","The update was applied successfully")
	ControlClick("Office 2003 Service Pack 3 (SP3)","The update was applied successfully","OK")
		
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

