;===============================================================================
;
; Description:      Microsoft Office 2003 Pro Installer
; Syntax:           Microsoft_Office_2003.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs Microsoft Office 2003 Professional
;                   It includes our license key, so it should not be distributed (x'ed out)
; Last Modified:    12/6/06
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "MicrosoftOffice2003"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Office\OFFICE11\EXCEL.EXE"
;The expected file version.
$AppBinFileVersion = "11.0.5612.0"
;The installation source directory
$SourceDir = "\\server\share\applications\microsoft office 2003"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ("msiexec /i " & $TMPDIR & "\" & $AppName & "\" & "PRO11.MSI",@WindowsDir )
	
	WinWait( "Microsoft Office 2003 Setup","Product Key" )
	Sleep(200)
	Send("xxxxx")
	Sleep(200)
	Send("xxxxx")
	Sleep(200)
	Send("xxxxx")
	Sleep(200)
	Send("xxxxx")
	Sleep(200)
	Send("xxxxx")
	Sleep(1100)
	ControlClick("Microsoft Office 2003 Setup","Product Key","&Next >")

	WinWait( "Microsoft Office 2003 Setup","User Information" )
	Send("User{TAB}{TAB}")
	Send("University")
	ControlClick("Microsoft Office 2003 Setup","User Information","&Next >")
	
	WinWait("Microsoft Office 2003 Setup","End-User License" )
	ControlClick("Microsoft Office 2003 Setup","End-User License","Button1") 
	ControlClick("Microsoft Office 2003 Setup","End-User License","&Install")

	WinWait( "Microsoft Office 2003 Setup","Type of Installation" )
	ControlClick("Microsoft Office 2003 Setup","Type of Installation","C&omplete Install")
	ControlClick("Microsoft Office 2003 Setup","Type of Installation","&Next >")
	
	WinWait( "Microsoft Office 2003 Setup","Summary" )
	ControlClick("Microsoft Office 2003 Setup","Summary","&Install")
		
	WinWait("Microsoft Office 2003 Setup","Setup Completed" )
	ControlClick("Microsoft Office 2003 Setup","Setup Completed","&Finish")
	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

