;----------------------------------------------------------------------------
;
; AutoIt Version: 3.3.6.1
; Language:       English
; Platform:       Windows XP / Windows Vista / Windows 7 / Windows 8
; Author:         Joshua Morris
; Last Modified:  10/12/12
;
; Script Function:
;	Rewrites the Menu_Install.aut3 script to be used to build the Application
;	Installer by reading in a file of the desired program names and their
;	script names and outputing the menu script automatically from that 
;	information.
;       
;----------------------------------------------------------------------------

;---- Set Global Variables ----

;set maximum number of applications allowed to be listed in Software_List or Software_List_Checkboxes
$appmax = 165


;---- Open File to Write ----

	;builder assumes that a file Menu_Install.au3 exists in the same directory
	;builder will erases its contents and rewrite the application installer
	
	$menu = FileOpen("menu_install.au3",2)
	
	;display error if unable to open for writing
	If $menu = -1 Then
		MsgBox(0,"Error","Unable to open file: AppList.au3.")
		Exit
	EndIf

;---- Open File to Read ----

	;builder assumes that a file Software_List.txt exists in the same directory
	;and that this text file contains each program to be listed in the format
	;<Application Name>,<Application Script Name>
	;NOTE: no space after ","
	;all of these scripts should be in the hardcoded script location directory
	
	$software_list = FileOpen("Software_List.txt",0)
	
	;display error if unable to open for reading
	If $software_list = -1 Then
		MsgBox(0,"Error","Unable to open file: Software_List.txt.")
		Exit
	EndIf
	
;---- Read Software List ----

	;read in number of lines and store to array
	dim $line[$appmax]
	$i = 0
	While 1
		$line[$i] = FileReadLine($software_list)
		$i = $i+1
		If @error = -1 Then ExitLoop
	Wend
	
	;$i is now one value greater than the number of read lines, hence number of applications
	$num_apps = $i - 1
	
	;process application and script names
	dim $app_name[$appmax]
	dim $script_name[$appmax]
	dim $split_temp
	
	;StringSplit will make $split_temp[1] the app name and $split_temp[2] the script name
	$i = 0
	While $i < $num_apps
		$split_temp = StringSplit($line[$i],",")
		$app_name[$i] = $split_temp[1]
		$script_name[$i] = $split_temp[2]
		$i = $i+1
	Wend
	
	
;---- Print Header ----

	FileWriteLine($menu,";----------------------------------------------------------------------------")
	FileWriteLine($menu,";")
	FileWriteLine($menu,"; AutoIt Version: 3.3.6.1")
	FileWriteLine($menu,"; Language:       English")
	FileWriteLine($menu,"; Platform:       Windows XP, Vista, 7, 8")
	FileWriteLine($menu,"; Author:         Ryan Consol :: Basic GUI and checkbox layout")
	FileWriteLine($menu,";                 Joshua Morris :: File creation, GUI graphics, installation type checkboxes, restart option")
	FileWriteLine($menu,"; Last Modified:  " & @MON & "/" & @MDAY & "/" & @YEAR)
	FileWriteLine($menu,";")
	FileWriteLine($menu,"; Script Function:")
	FileWriteLine($menu,";   Creates a Menu to allow users to place a checkmark for the applications they wish to install. ")
	FileWriteLine($menu,";   The Menu assumes the existence of AppList.au3 script. This is copied onto the local desktop")
	FileWriteLine($menu,";   and populated with the application scripts to be run. AppList.au3 should already contain the following:")
	FileWriteLine($menu,";   		;in case UAC is on")
	FileWriteLine($menu,";   		#requireadmin")
	FileWriteLine($menu,";   		AutoItSetOption(""TrayIconDebug"",1)")
	FileWriteLine($menu,";   		Func _RunAU3($sFilePath)")
	FileWriteLine($menu,";   		Return RunWait(@AutoItExe & ' \\server\share\autoit\scripts\' & $sFilePath)")
	FileWriteLine($menu,";   		EndFunc   ;==>_RunAU3")
	FileWriteLine($menu,";   The Menu also assumes the existence of a Menu_Install_UAC.bat batch file. This is copied to the desktop. This") 
	FileWriteLine($menu,";   file contains a single line:")
	FileWriteLine($menu,";   		\\server\share\autoit.exe %USERPROFILE%\Desktop\AppList.au3")
	FileWriteLine($menu,";   to allow easy double-click execution of the customized AppList script on the current machine. By aggregating")
	FileWriteLine($menu,";   all of the scripts into the AppList, if UAC is on, there will only be one prompt in the begginning and none")
	FileWriteLine($menu,";   for subsequent program installations. ")
	FileWriteLine($menu,";----------------------------------------------------------------------------")
	FileWriteLine($menu,"")
	
;---- Print Include Files ----

	FileWriteLine($menu,"#include ""\\server\share\autoit\scripts\include\GUIConstantsEx.au3""   ;this is required for a GUI to work")
	FileWriteLine($menu,"#include ""\\server\share\autoit\scripts\include\StaticConstants.au3""   ;this is required for a GUI to work")
	
;---- Declare Variables ----

	;declare necessary variables for the script
	FileWriteLine($menu,"dim $file")
	FileWriteLine($menu,"dim $style")
	FileWriteLine($menu,"dim $font")
	FileWriteLine($menu,"dim $RUN")
	FileWriteLine($menu,"dim $EXIT")
	FileWriteLine($menu,"dim $CLEAR")
	
	;declare variables for the installation types
	FileWriteLine($menu,"dim $STANDARDINSTALL ;for standard install checkbox")
	FileWriteLine($menu,"dim $CURRENTUPDATE   ;for current update checkbox (edit func to have it check other boxes)")
	FileWriteLine($menu,"dim $EXPERIMENTALLAB ;for experimental install checkbox")
	FileWriteLine($menu,"dim $PAL             ;for political anaylsis lab (PAL) checkbox")
	FileWriteLine($menu,"dim $125             ;for 125/150 lab checkbox")
	FileWriteLine($menu,"dim $RESTART		  ;for restart checkbox")
	FileWriteLine($menu,"dim $GRADOFFICE	  ;for grad office checkbox")
	FileWriteLine($menu,"dim $MSUPDATE        ;for ms update checkbox")
	FileWriteLine($menu,"")
	
	FileWriteLine($menu,"dim $statusstandardinstall		; evaluate if Standard Install box checked")
	FileWriteLine($menu,"dim $standardprevchecked = 0 	; evaluate if Standard Install box previously checked")
	FileWriteLine($menu,"dim $statuscurrentupdate		; evaluate if Current Update box checked")
	FileWriteLine($menu,"dim $currentprevchecked = 0	; evaluate if Current Update box previously checked")
	FileWriteLine($menu,"dim $statusexperimental		; evaluate if Experimental Lab box checked")
	FileWriteLine($menu,"dim $experimentalprevchecked = 0 	; evaluate if Experimental Lab previously checked")
	FileWriteLine($menu,"dim $statuspal		            ; evaluate if PAL box checked")
	FileWriteLine($menu,"dim $palprevchecked = 0		; evaluate if PAL previously checked")
	FileWriteLine($menu,"dim $status125                 ; evaluate if 125 box checked")
	FileWriteLine($menu,"dim $125prevchecked = 0        ; evaluate if 125 previously checked")
	FileWriteLine($menu,"dim $statusrestart          	; evaluate if Restart box checked")
	FileWriteLine($menu,"dim $statusgrad                ; evaluate if grad box checked")
	FileWriteLine($menu,"dim $gradprevchecked = 0       ; evaluate if grad box previously checked")
	FileWriteLine($menu,"dim $statusmsupdate            ; evaluate if msupdate checked")
	FileWriteLine($menu,"dim $msupdateprevchecked = 0   ; evaluate if msupdate previously checked")
	FileWriteLine($menu,"")
	
	;generate variables for number of applications
	$i = 0
	While $i < $num_apps
		FileWriteLine($menu,"dim $APP" & $i &"_CHKBOX")
		FileWriteLine($menu,"dim $status" & $i)
		$i = $i+1
	Wend
	FileWriteLine($menu,"")
	
;---- Print GUI ----

	$boxheight = 190 + Ceiling($num_apps/3) * 20 + 40
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,";This creates the inital GUI box")
	FileWriteLine($menu,"GUICreate (""Application Installer"",800," & $boxheight & ") ; create gui") ;previously 580
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"$backgroundlabel = GUICtrlCreateLabel("""",5,5,790,160)	; create background")
	FileWriteLine($menu,"GUICtrlSetBkColor($backgroundlabel,0xFFFFFF)	; set background to white")
	FileWriteLine($menu,"GUICtrlSetState($backgroundlabel,$GUI_DISABLE) ; disable background so other controls work")
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"; banner border")
	FileWriteLine($menu,"GUICtrlCreateLabel("""",5,5,790,70) ;outer border")
	FileWriteLine($menu,"GUICtrlSetBkColor(-1,0x808080)")
	FileWriteLine($menu,"GUICtrlSetState(-1,$GUI_DISABLE)")
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"; banner")
	FileWriteLine($menu,"$font = ""Georgia"" ; set font")
	FileWriteLine($menu,"GUISetFont(14,600,$font) ; set font size")
	FileWriteLine($menu,"$style = $SS_CENTERIMAGE ; set style for text")
	FileWriteLine($menu,"GUICtrlCreatePic(""\\server\share\autoit\applicationinstallerbanner.gif"",205,20,0,0)")
	;FileWriteLine($menu,"$banner = GUICtrlCreateLabel(""          Application Installer"",205,25,380,-1,$style) ; banner text")
	;FileWriteLine($menu,"GUICtrlSetBkColor($banner,0xFFFFFF) ; set banner background color")
	;FileWriteLine($menu,"GUICtrlSetColor($banner,0x000000) ; set banner text color")
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"; type checkboxes")
	FileWriteLine($menu,"GUICtrlCreatePic(""\\server\share\autoit\autoinstall.jpg"",10,90,0,0)")
	FileWriteLine($menu,"$spacer = GUICtrlCreateLabel("""",550,100,5,60) ; spacer label")
	FileWriteLine($menu,"GUICtrlSetBkColor($spacer,0x000000) ; spacer color")
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"GUISetFont(8.2,400,$font)")
	FileWriteLine($menu,"$STANDARDINSTALL = GUICtrlCreateCheckbox(""Standard Install"",250,100)  ;Checkbox Standard Install")
	FileWriteLine($menu,"$125 = GUICtrlCreateCheckbox(""125/150"",360,100)  ;Checkbox 125/150")
	FileWriteLine($menu,"$EXPERIMENTALLAB = GUICtrlCreateCheckbox(""Experimental Lab"",250,130)  ;Checkbox Experimental Lab")
	FileWriteLine($menu,"$PAL = GUICtrlCreateCheckbox(""PAL"",360,130)  ;Checkbox Current Update")
	FileWriteLine($menu,"$RESTART = GUICtrlCreateCheckbox(""Restart"",600,100)  ;Checkbox Restart")
	FileWriteLine($menu,"$CURRENTUPDATE = GUICtrlCreateCheckBox(""Current Update"",600,130)  ;Checkbox Current Update")
	FileWriteLine($menu,"$GRADOFFICE = GUICtrlCreateCheckBox(""Grad Office"",450,100)  ;Checkbox Current Update")
	FileWriteLine($menu,"$MSUPDATE = GUICtrlCreateCheckbox(""MS Update"",710,100)	;Checkbox MS Update")
	
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"; set install type background colors")
	FileWriteLine($menu,"GUICtrlSetBkColor($STANDARDINSTALL,0xFFFFFF)")
	FileWriteLine($menu,"GUICtrlSetBkColor($CURRENTUPDATE,0xFFFFFF) ")
	FileWriteLine($menu,"GUICtrlSetBkColor($EXPERIMENTALLAB,0xFFFFFF) ")
	FileWriteLine($menu,"GUICtrlSetBkColor($PAL,0xFFFFFF) ")
	FileWriteLine($menu,"GUICtrlSetBkColor($125,0xFFFFFF) ")
	FileWriteLine($menu,"GUICtrlSetBkColor($RESTART,0xFFFFFF) ")
	FileWriteLine($menu,"GUICtrlSetBkColor($GRADOFFICE,0xFFFFFF)")
	FileWriteLine($menu,"GUICtrlSetBkColor($MSUPDATE,0xFFFFFF)")
	
	FileWriteLine($menu,"")
	FileWriteLine($menu,"; set install type checkbox tips")
	FileWriteLine($menu,"GUICtrlSetTip($STANDARDINSTALL,""Typical applications for a departmental machine."")")
	FileWriteLine($menu,"GUICtrlSetTip($CURRENTUPDATE,""Temporary list for apps being updated on multiple machines."")")
	FileWriteLine($menu,"GUICtrlSetTip($EXPERIMENTALLAB,""Applications for Experimental Lab 2049A."")")
	FileWriteLine($menu,"GUICtrlSetTip($PAL,""Applicaions for PAL 2037."")")
	FileWriteLine($menu,"GUICtrlSetTip($125,""Applications for 125 and 150 labs."")")
	FileWriteLine($menu,"GUICtrlSetTip($RESTART,""Sets to restart the machine at completion."")")
	FileWriteLine($menu,"GUICtrlSetTip($GRADOFFICE,""Applications for graduate offices."")")
	FileWriteLine($menu,"GUICtrlSetTip($MSUPDATE,""Enable Microsoft Updates."")")
	FileWriteLine($menu,"")
	
	FileWriteLine($menu,"")
	
	FileWriteLine($menu,"GUISetFont(8.5,400,$font)")
	
;---- Print Application Checkboxes ----

	;i is a counter
	$i = 0
	
	;horizontal distance between columns
	$app_horz_distance = 260
	
	;y is vertical placement of boxes
	$app_vertical_start = 180
	$y = $app_vertical_start
	
	;print left column
	While $i < $num_apps/3
		FileWriteLine($menu, "$APP" & $i & "_CHKBOX = GUICtrlCreateCheckbox(""" & $app_name[$i] & """,10," & $y & ")  ;Checkbox " & $i)
		$i = $i+1
		$y = $y + 20
	Wend
	;print middle column
	$y = $app_vertical_start
	While $i >= $num_apps/3 AND $i < $num_apps * 2/3
		FileWriteLine($menu, "$APP" & $i & "_CHKBOX = GUICtrlCreateCheckbox(""" & $app_name[$i] & """," & 10 + $app_horz_distance & "," & $y & ")  ;Checkbox " & $i)
		$i = $i+1
		$y = $y + 20
	Wend
	;print right column
	$y = $app_vertical_start
	While $i >= $num_apps * 2/3 AND $i < $num_apps
		FileWriteLine($menu, "$APP" & $i & "_CHKBOX = GUICtrlCreateCheckbox(""" & $app_name[$i] & """," & 10 + $app_horz_distance * 2 & "," & $y & ")  ;Checkbox " & $i)
		$i = $i+1
		$y = $y + 20
	Wend



;---- Print Install, Clear, & Exit buttons, Get Status --- 

	;increase y value to separate Install & Exits buttons
	$y = $app_vertical_start + Ceiling($num_apps/3) * 20 + 20

	FileWriteLine($menu,"")
	FileWriteLine($menu,"$RUN = GUICtrlCreateButton(""Install"",10," & $y & ",120,20)  ;This is the Install button")
	FileWriteLine($menu,"$CLEAR = GUICtrlCreateButton(""Clear Boxes""," & 10 + $app_horz_distance & "," & $y & ",120,20)  ;This is the Clear Boxes button")
	FileWriteLine($menu,"$EXIT = GUICtrlCreateButton(""Exit""," & 10 + $app_horz_distance * 2 & "," & $y & ",120,20)  ;This causes the application to exit")
	FileWriteLine($menu,"GUICtrlSetTip($RUN,""Create installation batch file."")")
	FileWriteLine($menu,"GUICtrlSetTip($CLEAR,""Clear application check boxes."")")
	FileWriteLine($menu,"GUICtrlSetTip($EXIT,""Exit the application installer."")")
	;display whether UAC is on or off
	FileWriteLine($menu,"$UAC = RegRead(""HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System"",""EnableLUA"") ;read UAC registry key")
	FileWriteLine($menu,"If($UAC == 1) Then ;Show whether UAC is on or not")
	FileWriteLine($menu,"	GUICtrlCreateLabel(""!!! UAC is on !!!"",155," & $y & ") ;UAC is On")
	FileWriteLine($menu,"Else")
	FileWriteLine($menu,"	GUICtrlCreateLabel(""UAC is off"",155," & $y & ") ;UAC is Off")
	FileWriteLine($menu,"EndIf")
	
	FileWriteLine($menu,"GUISetState()")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"Do")
	FileWriteLine($menu,"$msg = GUIGetMsg()")
	FileWriteLine($menu,"")
	;check for commandline options
	FileWriteLine($menu,";check for commandline parameters")
	FileWriteLine($menu,"If $CmdLine[0] > 0 Then")
	FileWriteLine($menu,"	If $CmdLine[1] == ""pal"" Then")
	FileWriteLine($menu,"		$statuspal = 1")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"	If $CmdLine[1] == ""exp"" Then")
	FileWriteLine($menu,"		$statusexperimental = 1")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"	If $CmdLine[1] == ""grad"" Then")
	FileWriteLine($menu,"		$statusgrad = 1")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"	If $CmdLine[1] == ""125"" Then")
	FileWriteLine($menu,"		$status125 = 1")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"	If $CmdLine[1] == ""standard"" Then")
	FileWriteLine($menu,"		$statusstandardinstall = 1")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"EndIf")
	FileWriteLine($menu,"")
	
	;read install type boxes 
	FileWriteLine($menu,";see if any install types have changed")
	FileWriteLine($menu,"If $statusstandardinstall <> $standardprevchecked OR $statuscurrentupdate <> $currentprevchecked OR $statusexperimental <> $experimentalprevchecked OR $statuspal <> $palprevchecked  OR $status125 <> $125prevchecked OR $statusgrad <> $gradprevchecked Then")
	FileWriteLine($menu,"  call(""Recheck_Boxes"")")
	FileWriteLine($menu,"EndIf")
	FileWriteLine($menu,"")
	
	;read the status of the checkboxes	
	FileWriteLine($menu,";Reads the status of the Checkboxes and sets a variable to either 1 for checked or 4 for not checked")
	FileWriteLine($menu,";This HAS to be included before the UNTIL statement")
	
	;generate status checks for application boxes
	$i = 0
	While $i < $num_apps
		FileWriteLine($menu,"$status" & $i &" = GUICtrlRead($APP" & $i & "_CHKBOX)")
		$i = $i+1
	Wend
	
	;print status checks for installation types
	FileWriteLine($menu,"$statusstandardinstall = GUICtrlRead($STANDARDINSTALL)")
	FileWriteLine($menu,"$statuscurrentupdate = GUICtrlRead($CURRENTUPDATE)")
	FileWriteLine($menu,"$statusexperimental = GUICtrlRead($EXPERIMENTALLAB)")
	FileWriteLine($menu,"$statuspal = GUICtrlRead($PAL)")
	FileWriteLine($menu,"$statusrestart = GUICtrlRead($RESTART)")
	FileWriteLine($menu,"$status125 = GUICtrlRead($125)")
	FileWriteLine($menu,"$statusgrad = GUICtrlRead($GRADOFFICE)")
	FileWriteLine($menu,"$statusmsupdate = GUICtrlRead($MSUPDATE)")
	FileWriteLine($menu,"")
			
	;offset is 16 due to 14 other controls before the first application checkbox (confirm with AU3Info.exe)
	$offset = 16 ;control number of the first application box
	$num_typeboxes = 5 ;number of type of install boxes
		
	FileWriteLine($menu,"If $msg = $CLEAR Then")
	FileWriteLine($menu,"	call (""Clear"")")
    FileWriteLine($menu,"EndIf")
	
	;enable X button
	FileWriteLine($menu,"; close if X button pressed")
	FileWriteLine($menu,"If $msg = $GUI_EVENT_CLOSE Then")
	FileWriteLine($menu,"  Exit")
	FileWriteLine($menu,"EndIf")
	
	; if commandline option used, run automatically
	FileWriteLine($menu,"; if commandline option used, run automatically")
	FileWriteLine($menu,"If $CmdLine[0] > 0 Then")
	FileWriteLine($menu,"	$msg = $RUN")
	FileWriteLine($menu,"EndIf")
	
	;print end of do-until loop	
	FileWriteLine($menu,"Until $msg = $EXIT or $msg = $RUN")
	FileWriteLine($menu,"If $msg = $EXIT then Exit")
	FileWriteLine($menu,"")
	
;---- Copy BAT file to HDD and write the selected software lines ----

	;copy files
	FileWriteLine($menu,"$TMPDIR = EnvGet (""TEMP"")")
	FileWriteLine($menu,"FileCopy(""\\server\share\autoit\menu_install.bat"",@DesktopDir,9)")
	FileWriteLine($menu,"FileCopy(""\\server\share\autoit\AppList.au3"",@DesktopDir,9)")
	FileWriteLine($menu,"FileCopy(""\\server\share\autoit\autoit3.exe"",$TMPDIR,9)")
	FileWriteLine($menu,"DirCopy(""\\server\share\autoit\scripts"",$TMPDIR & ""\scripts"",1)")
	FileWriteLine($menu,"$file = FileOpen(@DesktopDir & ""\AppList.au3"",1)")
	FileWriteLine($menu,"")
	
	;print calls to check status of checkboxes
	FileWriteLine($menu,";Checks the status of the Checkboxes and calls the application function(s) if the checkbox is enabled")
	$i = 0
	While $i < $num_apps
		FileWriteLine($menu,"IF $status" & $i & " = 1 then call (""APP_" & $i & """)")
		$i = $i+1
	Wend
	FileWriteLine($menu,"IF $statusmsupdate = 1 Then Call (""MSUpdate"")")
	FileWriteLine($menu,"IF $statusrestart = 1 Then Call (""Restart"")")
	FileWriteLine($menu,"Call (""END_APP"")")
	FileWriteLine($menu,"")
	
;---- Application Functions ----

	FileWriteLine($menu,";Add Application Functions here")
	
	$i = 0
	While $i < $num_apps
		FileWriteLine($menu,"Func APP_" & $i & "() ;Function for application " & $i)
		FileWriteLine($menu,"  FileWriteLine($file," & '"' & "_RunAU3('" & $script_name[$i] & ".au3')"")")
		FileWriteLine($menu,"EndFunc")
		FileWriteLine($menu,"")
		$i = $i+1
	Wend

;---- Install Checkbox Reading Function ----

	;GUI control numbers may change if other boxes are added

	FileWriteLine($menu,"Func Recheck_Boxes()")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	;keep old values")
	FileWriteLine($menu,"	$restart_temp = $statusrestart")
	FileWriteLine($menu,"	$standard_temp = $statusstandardinstall")
	FileWriteLine($menu,"	$current_temp = $statuscurrentupdate ")
	FileWriteLine($menu,"	$experimental_temp = $statusexperimental ")
	FileWriteLine($menu,"	$pal_temp = $statuspal  ")
	FileWriteLine($menu,"	$125_temp = $status125 ")
	FileWriteLine($menu,"	$grad_temp = $statusgrad")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	;clear previous selections")
	FileWriteLine($menu,"	call(""Clear"")")
	FileWriteLine($menu,"	;set MS Updates")
	FileWriteLine($menu,"	call(""SetMSUpdate"")")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	;recheck types if checked")
	FileWriteLine($menu,"	If $standard_temp == $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(8,$GUI_CHECKED)")
	FileWriteLine($menu,"		call(""StandardInstall"")")
	FileWriteLine($menu,"		$standardprevchecked = $GUI_CHECKED")
	FileWriteLine($menu,"	Else")
	FileWriteLine($menu,"		$standardprevchecked = $GUI_UNCHECKED")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	If $current_temp == $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(13,$GUI_CHECKED)")
	FileWriteLine($menu,"		call(""CurrentUpdate"")")
	FileWriteLine($menu,"		$currentprevchecked = $GUI_CHECKED")
	FileWriteLine($menu,"	Else")
	FileWriteLine($menu,"		$currentprevchecked = $GUI_UNCHECKED")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	If $experimental_temp = $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(10,$GUI_CHECKED)")
	FileWriteLine($menu,"		call(""ExperimentalLab"")")
	FileWriteLine($menu,"		$experimentalprevchecked = $GUI_CHECKED")
	FileWriteLine($menu,"	Else")
	FileWriteLine($menu,"		$experimentalprevchecked = $GUI_UNCHECKED")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	If $pal_temp = $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(11,$GUI_CHECKED)")
	FileWriteLine($menu,"		call(""PAL"")")
	FileWriteLine($menu,"		$palprevchecked = $GUI_CHECKED")
	FileWriteLine($menu,"	Else")
	FileWriteLine($menu,"		$palprevchecked = $GUI_UNCHECKED")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	If $125_temp = $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(9,$GUI_CHECKED)")
	FileWriteLine($menu,"		call(""Box125"")")
	FileWriteLine($menu,"		$125prevchecked = $GUI_CHECKED")
	FileWriteLine($menu,"	Else")
	FileWriteLine($menu,"		$125prevchecked = $GUI_UNCHECKED")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	If $grad_temp = $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(14,$GUI_CHECKED)")
	FileWriteLine($menu,"		call(""GradOffice"")")
	FileWriteLine($menu,"		$gradprevchecked = $GUI_CHECKED")
	FileWriteLine($menu,"	Else")
	FileWriteLine($menu,"		$gradprevchecked = $GUI_UNCHECKED")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"	If $restart_temp = $GUI_CHECKED Then")
	FileWriteLine($menu,"		GUICtrlSetState(12,$GUI_CHECKED)")
	FileWriteLine($menu,"	EndIf")
	FileWriteLine($menu,"")
	FileWriteLine($menu,"EndFunc")
	FileWriteLine($menu,"")

;---- Install Type Functions ----

	;see $offset variable at the end of the Print Install, Clear, & Exit Buttons section
	
	;---- Open File to Read ----

	;builder assumes that a file Software_List_Checkboxes.txt exists in the same directory
	;and that this text file contains each program to be listed in the format
	;<Checkbox Name>,<Application Script Name>
	;NOTE: no space after ","
	;all of these scripts should be in the hardcoded script location directory
	;<Checkbox Name> should be one of {Standard,Experimental,PAL,Current,125}
	
	$checkbox_list = FileOpen("Software_List_Checkboxes.txt",0)
	
	;display error if unable to open for reading
	If $checkbox_list = -1 Then
		MsgBox(0,"Error","Unable to open file: Software_List_Checkboxes.txt.")
		Exit
	EndIf
	
;---- Read Software List ----

	;read in number of lines and store to array
	dim $line[$appmax]
	$i = 0
	While 1
		$line[$i] = FileReadLine($checkbox_list)
		$i = $i+1
		If @error = -1 Then ExitLoop
	Wend
	
	;$i is now one value greater than the number of read lines, hence number of applications
	dim $num_apps_checkboxes = $i - 1
	
	;process checkbox and script names
	dim $box_name[$appmax]
	dim $box_script_name[$appmax]
	dim $split_temp
	
	;StringSplit will make $split_temp[1] the checkbox name and $split_temp[2] the script name
	$i = 0
	While $i < $num_apps_checkboxes
		$split_temp = StringSplit($line[$i],",")
		$box_name[$i] = $split_temp[1]
		$box_script_name[$i] = $split_temp[2]
		$i = $i+1
	Wend
		
	;--- check Standard Install boxes ---
	;write first line of function
	FileWriteLine($menu,"Func StandardInstall(); Function for standard install checkbox")
	$i = 0 
	;for every app in Software_List
	While $i < $num_apps
		$j = 0
		;check against all apps in Software_List_Checkboxes for match
		While $j < $num_apps_checkboxes
			;if match found, add that app to the function to check it's box
			If $script_name[$i] == $box_script_name[$j] and $box_name[$j] == "Standard" Then
				FileWriteLine($menu,"	GUICtrlSetState (" & $offset + $i & ", $GUI_CHECKED)")
			EndIf
			$j = $j + 1
		WEnd
		$i = $i + 1
	WEnd
	FileWriteLine($menu,"EndFunc")
	;--- end check Standard Install boxes ---
	
	;--- check Current Update boxes ---
	;write first line of function
	FileWriteLine($menu,"Func CurrentUpdate(); Function for current update checkbox")
	$i = 0 
	;for every app in Software_List
	While $i < $num_apps
		$j = 0
		;check against all apps in Software_List_Checkboxes for match
		While $j < $num_apps_checkboxes
			;if match found, add that app to the function to check it's box
			If $script_name[$i] == $box_script_name[$j] and $box_name[$j] == "Current" Then
				FileWriteLine($menu,"	GUICtrlSetState (" & $offset + $i & ", $GUI_CHECKED)")
			EndIf
			$j = $j + 1
		WEnd
		$i = $i + 1
	WEnd
	FileWriteLine($menu,"EndFunc")
	;--- end check Current Update boxes ---
	
	;--- check Experimental Lab boxes ---
	;write first line of function
	FileWriteLine($menu,"Func ExperimentalLab(); Function for experimental lab checkbox")
	$i = 0 
	;for every app in Software_List
	While $i < $num_apps
		$j = 0
		;check against all apps in Software_List_Checkboxes for match
		While $j < $num_apps_checkboxes
			;if match found, add that app to the function to check it's box
			If $script_name[$i] == $box_script_name[$j] and $box_name[$j] == "Experimental" Then
				FileWriteLine($menu,"	GUICtrlSetState (" & $offset + $i & ", $GUI_CHECKED)")
			EndIf
			$j = $j + 1
		WEnd
		$i = $i + 1
	WEnd
	FileWriteLine($menu,"EndFunc")
	;--- end check Experimental Lab boxes ---
	
	;--- check PAL boxes ---
	;write first line of function
	FileWriteLine($menu,"Func PAL(); Function for pal checkbox")
	$i = 0 
	;for every app in Software_List
	While $i < $num_apps
		$j = 0
		;check against all apps in Software_List_Checkboxes for match
		While $j < $num_apps_checkboxes
			;if match found, add that app to the function to check it's box
			If $script_name[$i] == $box_script_name[$j] and $box_name[$j] == "PAL" Then
				FileWriteLine($menu,"	GUICtrlSetState (" & $offset + $i & ", $GUI_CHECKED)")
			EndIf
			$j = $j + 1
		WEnd
		$i = $i + 1
	WEnd
	FileWriteLine($menu,"EndFunc")
	;--- end check PAL boxes ---
	
	;--- check 125/150 boxes ---
	;write first line of function
	FileWriteLine($menu,"Func Box125(); Function for 125/150 lab checkbox")
	$i = 0 
	;for every app in Software_List
	While $i < $num_apps
		$j = 0
		;check against all apps in Software_List_Checkboxes for match
		While $j < $num_apps_checkboxes
			;if match found, add that app to the function to check it's box
			If $script_name[$i] == $box_script_name[$j] and $box_name[$j] == "125" Then
				FileWriteLine($menu,"	GUICtrlSetState (" & $offset + $i & ", $GUI_CHECKED)")
			EndIf
			$j = $j + 1
		WEnd
		$i = $i + 1
	WEnd
	FileWriteLine($menu,"EndFunc")
	;--- end check 125 boxes ---
	
	;--- check grad office box ---
	;write first line of function
	FileWriteLine($menu,"Func GradOffice(); Function for grad office checkbox")
	$i = 0 
	;for every app in Software_List
	While $i < $num_apps
		$j = 0
		;check against all apps in Software_List_Checkboxes for match
		While $j < $num_apps_checkboxes
			;if match found, add that app to the function to check it's box
			If $script_name[$i] == $box_script_name[$j] and $box_name[$j] == "Grad" Then
				FileWriteLine($menu,"	GUICtrlSetState (" & $offset + $i & ", $GUI_CHECKED)")
			EndIf
			$j = $j + 1
		WEnd
		$i = $i + 1
	WEnd
	FileWriteLine($menu,"EndFunc")
	;--- end check grad boxes ---
	
	
;---- Clear Boxes Function ----
	FileWriteLine($menu,"Func Clear()")
	FileWriteLine($menu,"  ;clear all check boxes")
	FileWriteLine($menu,"  For $i = " & $offset - $num_typeboxes & " to " & $num_apps + $offset -1) ;controls start at offset and go until the number of apps (minus one due to it being a zero index)
	FileWriteLine($menu,"    GUICtrlSetState ($i, $GUI_UNCHECKED)")
	FileWriteLine($menu,"  Next")
	FileWriteLine($menu,"EndFunc")
	FileWriteLine($menu,"")
	
;---- Set MS Update Function ----
	FileWriteLine($menu,"Func SetMSUpdate()")
	FileWriteLine($menu,"  GUICtrlSetState(15, $GUI_CHECKED)")
    FileWriteLine($menu,"EndFunc")
	FileWriteLine($menu,"")
	
;---- MS Update Function ----
	FileWriteLine($menu,"Func MSUpdate()")
	FileWriteLine($menu,"  FileWriteLine($file," & '"' & "_RunAU3('msupdates_optin.au3')"")")
    FileWriteLine($menu,"EndFunc")
	FileWriteLine($menu,"")

;---- Restart Function ----
	FileWriteLine($menu,"Func Restart()")
	; DOS shutdown command "shutdown -r -c "Restart for software installation""
	; AutoIt shutdown command Shutdown(code,reason)
	FileWriteLine($menu,"  FileWriteLine($file,""Sleep(1000)"")")
	FileWriteLine($menu,"  FileWriteLine($file,""Run(@ComSpec & """" /k shutdown -r -c """"""""Restart for software installation"""""""" -d p:04:02"""")"")") ;Planned Application Maintenance retart
	FileWriteLine($menu,"EndFunc")
	FileWriteLine($menu,"")

;---- End Function ----

	FileWriteLine($menu,"Func END_APP()")
	FileWriteLine($menu,"  MsgBox(4096,""Complete"",""Custom software list created for selected applications. Run 'menu_install.bat' from the Desktop."",2)")
	FileWriteLine($menu,"EndFunc")
	
;---- Notify User of Completion ----

	MsgBox(0,"Menu Install Builder","The script has been rewritten.")

	
