;----------------------------------------------------------------------------
;
; AutoIt Version: 3.3.6.1
; Language:       English
; Platform:       Windows XP, Vista, 7, 8
; Author:         Ryan Consol :: Basic GUI and checkbox layout
;                 Joshua Morris :: File creation, GUI graphics, installation type checkboxes, restart option
; Last Modified:  10/17/2012
;
; Script Function:
;   Creates a Menu to allow users to place a checkmark for the applications they wish to install. 
;   The Menu assumes the existence of AppList.au3 script. This is copied onto the local desktop
;   and populated with the application scripts to be run. AppList.au3 should already contain the following:
;   		;in case UAC is on
;   		#requireadmin
;   		AutoItSetOption("TrayIconDebug",1)
;   		Func _RunAU3($sFilePath)
;   		Return RunWait(@AutoItExe & ' \\server\share\autoit\scripts\' & $sFilePath)
;   		EndFunc   ;==>_RunAU3
;   The Menu also assumes the existence of a Menu_Install_UAC.bat batch file. This is copied to the desktop. This
;   file contains a single line:
;   		\\server\share\autoit.exe %USERPROFILE%\Desktop\AppList.au3
;   to allow easy double-click execution of the customized AppList script on the current machine. By aggregating
;   all of the scripts into the AppList, if UAC is on, there will only be one prompt in the begginning and none
;   for subsequent program installations. 
;----------------------------------------------------------------------------

#include "\\server\share\autoit\scripts\include\GUIConstantsEx.au3"   ;this is required for a GUI to work
#include "\\server\share\autoit\scripts\include\StaticConstants.au3"   ;this is required for a GUI to work
dim $file
dim $style
dim $font
dim $RUN
dim $EXIT
dim $CLEAR
dim $STANDARDINSTALL ;for standard install checkbox
dim $CURRENTUPDATE   ;for current update checkbox (edit func to have it check other boxes)
dim $EXPERIMENTALLAB ;for experimental install checkbox
dim $PAL             ;for political anaylsis lab (PAL) checkbox
dim $125             ;for 125/150 lab checkbox
dim $RESTART		  ;for restart checkbox
dim $GRADOFFICE	  ;for grad office checkbox
dim $MSUPDATE        ;for ms update checkbox

dim $statusstandardinstall		; evaluate if Standard Install box checked
dim $standardprevchecked = 0 	; evaluate if Standard Install box previously checked
dim $statuscurrentupdate		; evaluate if Current Update box checked
dim $currentprevchecked = 0	; evaluate if Current Update box previously checked
dim $statusexperimental		; evaluate if Experimental Lab box checked
dim $experimentalprevchecked = 0 	; evaluate if Experimental Lab previously checked
dim $statuspal		            ; evaluate if PAL box checked
dim $palprevchecked = 0		; evaluate if PAL previously checked
dim $status125                 ; evaluate if 125 box checked
dim $125prevchecked = 0        ; evaluate if 125 previously checked
dim $statusrestart          	; evaluate if Restart box checked
dim $statusgrad                ; evaluate if grad box checked
dim $gradprevchecked = 0       ; evaluate if grad box previously checked
dim $statusmsupdate            ; evaluate if msupdate checked
dim $msupdateprevchecked = 0   ; evaluate if msupdate previously checked

dim $APP0_CHKBOX
dim $status0
dim $APP1_CHKBOX
dim $status1
dim $APP2_CHKBOX
dim $status2
dim $APP3_CHKBOX
dim $status3
dim $APP4_CHKBOX
dim $status4
dim $APP5_CHKBOX
dim $status5
dim $APP6_CHKBOX
dim $status6
dim $APP7_CHKBOX
dim $status7
dim $APP8_CHKBOX
dim $status8
dim $APP9_CHKBOX
dim $status9
dim $APP10_CHKBOX
dim $status10
dim $APP11_CHKBOX
dim $status11
dim $APP12_CHKBOX
dim $status12
dim $APP13_CHKBOX
dim $status13
dim $APP14_CHKBOX
dim $status14
dim $APP15_CHKBOX
dim $status15
dim $APP16_CHKBOX
dim $status16
dim $APP17_CHKBOX
dim $status17
dim $APP18_CHKBOX
dim $status18
dim $APP19_CHKBOX
dim $status19
dim $APP20_CHKBOX
dim $status20
dim $APP21_CHKBOX
dim $status21
dim $APP22_CHKBOX
dim $status22
dim $APP23_CHKBOX
dim $status23
dim $APP24_CHKBOX
dim $status24
dim $APP25_CHKBOX
dim $status25
dim $APP26_CHKBOX
dim $status26
dim $APP27_CHKBOX
dim $status27
dim $APP28_CHKBOX
dim $status28
dim $APP29_CHKBOX
dim $status29
dim $APP30_CHKBOX
dim $status30
dim $APP31_CHKBOX
dim $status31
dim $APP32_CHKBOX
dim $status32
dim $APP33_CHKBOX
dim $status33
dim $APP34_CHKBOX
dim $status34
dim $APP35_CHKBOX
dim $status35
dim $APP36_CHKBOX
dim $status36
dim $APP37_CHKBOX
dim $status37
dim $APP38_CHKBOX
dim $status38
dim $APP39_CHKBOX
dim $status39
dim $APP40_CHKBOX
dim $status40
dim $APP41_CHKBOX
dim $status41
dim $APP42_CHKBOX
dim $status42
dim $APP43_CHKBOX
dim $status43
dim $APP44_CHKBOX
dim $status44
dim $APP45_CHKBOX
dim $status45
dim $APP46_CHKBOX
dim $status46
dim $APP47_CHKBOX
dim $status47


;This creates the inital GUI box
GUICreate ("Application Installer",800,550) ; create gui

$backgroundlabel = GUICtrlCreateLabel("",5,5,790,160)	; create background
GUICtrlSetBkColor($backgroundlabel,0xFFFFFF)	; set background to white
GUICtrlSetState($backgroundlabel,$GUI_DISABLE) ; disable background so other controls work

; banner border
GUICtrlCreateLabel("",5,5,790,70) ;outer border
GUICtrlSetBkColor(-1,0x808080)
GUICtrlSetState(-1,$GUI_DISABLE)

; banner
$font = "Georgia" ; set font
GUISetFont(14,600,$font) ; set font size
$style = $SS_CENTERIMAGE ; set style for text
GUICtrlCreatePic("\\server\share\autoit\applicationinstallerbanner.gif",205,20,0,0)

; type checkboxes
GUICtrlCreatePic("\\server\share\autoit\autoinstall.jpg",10,90,0,0)
$spacer = GUICtrlCreateLabel("",550,100,5,60) ; spacer label
GUICtrlSetBkColor($spacer,0x000000) ; spacer color

GUISetFont(8.2,400,$font)
$STANDARDINSTALL = GUICtrlCreateCheckbox("Standard Install",250,100)  ;Checkbox Standard Install
$125 = GUICtrlCreateCheckbox("125/150",360,100)  ;Checkbox 125/150
$EXPERIMENTALLAB = GUICtrlCreateCheckbox("Experimental Lab",250,130)  ;Checkbox Experimental Lab
$PAL = GUICtrlCreateCheckbox("PAL",360,130)  ;Checkbox Current Update
$RESTART = GUICtrlCreateCheckbox("Restart",600,100)  ;Checkbox Restart
$CURRENTUPDATE = GUICtrlCreateCheckBox("Current Update",600,130)  ;Checkbox Current Update
$GRADOFFICE = GUICtrlCreateCheckBox("Grad Office",450,100)  ;Checkbox Current Update
$MSUPDATE = GUICtrlCreateCheckbox("MS Update",710,100)	;Checkbox MS Update

; set install type background colors
GUICtrlSetBkColor($STANDARDINSTALL,0xFFFFFF)
GUICtrlSetBkColor($CURRENTUPDATE,0xFFFFFF) 
GUICtrlSetBkColor($EXPERIMENTALLAB,0xFFFFFF) 
GUICtrlSetBkColor($PAL,0xFFFFFF) 
GUICtrlSetBkColor($125,0xFFFFFF) 
GUICtrlSetBkColor($RESTART,0xFFFFFF) 
GUICtrlSetBkColor($GRADOFFICE,0xFFFFFF)
GUICtrlSetBkColor($MSUPDATE,0xFFFFFF)

; set install type checkbox tips
GUICtrlSetTip($STANDARDINSTALL,"Typical applications for a departmental machine.")
GUICtrlSetTip($CURRENTUPDATE,"Temporary list for apps being updated on multiple machines.")
GUICtrlSetTip($EXPERIMENTALLAB,"Applications for Experimental Lab 2049A.")
GUICtrlSetTip($PAL,"Applicaions for PAL 2037.")
GUICtrlSetTip($125,"Applications for 125 and 150 labs.")
GUICtrlSetTip($RESTART,"Sets to restart the machine at completion.")
GUICtrlSetTip($GRADOFFICE,"Applications for graduate offices.")
GUICtrlSetTip($MSUPDATE,"Enable Microsoft Updates.")


GUISetFont(8.5,400,$font)
$APP0_CHKBOX = GUICtrlCreateCheckbox(".NET 2.0",10,180)  ;Checkbox 0
$APP1_CHKBOX = GUICtrlCreateCheckbox(".NET 3.5 SP1",10,200)  ;Checkbox 1
$APP2_CHKBOX = GUICtrlCreateCheckbox("Adobe Acrobat 10.1.4",10,220)  ;Checkbox 2
$APP3_CHKBOX = GUICtrlCreateCheckbox("Remove Reader 10.x.x",10,240)  ;Checkbox 3
$APP4_CHKBOX = GUICtrlCreateCheckbox("Amos 20",10,260)  ;Checkbox 4
$APP5_CHKBOX = GUICtrlCreateCheckbox("Dell PowerDVD 9.5",10,280)  ;Checkbox 5
$APP6_CHKBOX = GUICtrlCreateCheckbox("DirectRT 2008",10,300)  ;Checkbox 6
$APP7_CHKBOX = GUICtrlCreateCheckbox("EUGene 3.204",10,320)  ;Checkbox 7
$APP8_CHKBOX = GUICtrlCreateCheckbox("FileZilla 3.5.3",10,340)  ;Checkbox 8
$APP9_CHKBOX = GUICtrlCreateCheckbox("Firefox 15.0.1",10,360)  ;Checkbox 9
$APP10_CHKBOX = GUICtrlCreateCheckbox("HLM 7 Student",10,380)  ;Checkbox 10
$APP11_CHKBOX = GUICtrlCreateCheckbox("IE 9",10,400)  ;Checkbox 11
$APP12_CHKBOX = GUICtrlCreateCheckbox("iTunes 10.7",10,420)  ;Checkbox 12
$APP13_CHKBOX = GUICtrlCreateCheckbox("Java 7 Update 7",10,440)  ;Checkbox 13
$APP14_CHKBOX = GUICtrlCreateCheckbox("LANDesk Agent",10,460)  ;Checkbox 14
$APP15_CHKBOX = GUICtrlCreateCheckbox("McAfee VirusScan 8.8",10,480)  ;Checkbox 15
$APP16_CHKBOX = GUICtrlCreateCheckbox("MediaLab v2008.1.33",270,180)  ;Checkbox 16
$APP17_CHKBOX = GUICtrlCreateCheckbox("Microsoft Forefront 2010",270,200)  ;Checkbox 17
$APP18_CHKBOX = GUICtrlCreateCheckbox("Microsoft Forefront 2012",270,220)  ;Checkbox 18
$APP19_CHKBOX = GUICtrlCreateCheckbox("Microsoft FrontPage 2003",270,240)  ;Checkbox 19
$APP20_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2003",270,260)  ;Checkbox 20
$APP21_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2003 SP3",270,280)  ;Checkbox 21
$APP22_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2003 File Compatiblity",270,300)  ;Checkbox 22
$APP23_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2007",270,320)  ;Checkbox 23
$APP24_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2007 SP2",270,340)  ;Checkbox 24
$APP25_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2010",270,360)  ;Checkbox 25
$APP26_CHKBOX = GUICtrlCreateCheckbox("Microsoft Office 2010 SP1",270,380)  ;Checkbox 26
$APP27_CHKBOX = GUICtrlCreateCheckbox("Miktex 2.9.4407",270,400)  ;Checkbox 27
$APP28_CHKBOX = GUICtrlCreateCheckbox("Paint.NET 3.5.10",270,420)  ;Checkbox 28
$APP29_CHKBOX = GUICtrlCreateCheckbox("Quicktime 7.7.2",270,440)  ;Checkbox 29
$APP30_CHKBOX = GUICtrlCreateCheckbox("R 2.15.0",270,460)  ;Checkbox 30
$APP31_CHKBOX = GUICtrlCreateCheckbox("R Uninstaller",270,480)  ;Checkbox 31
$APP32_CHKBOX = GUICtrlCreateCheckbox("RStudio .96",530,180)  ;Checkbox 32
$APP33_CHKBOX = GUICtrlCreateCheckbox("Roxio Creator 10",530,200)  ;Checkbox 33
$APP34_CHKBOX = GUICtrlCreateCheckbox("SPSS License Renewal",530,220)  ;Checkbox 34
$APP35_CHKBOX = GUICtrlCreateCheckbox("SPSS 18 Shortcut Remover",530,240)  ;Checkbox 35
$APP36_CHKBOX = GUICtrlCreateCheckbox("SPSS 20",530,260)  ;Checkbox 36
$APP37_CHKBOX = GUICtrlCreateCheckbox("Stata 9",530,280)  ;Checkbox 37
$APP38_CHKBOX = GUICtrlCreateCheckbox("Stata 9.2 Patch",530,300)  ;Checkbox 38
$APP39_CHKBOX = GUICtrlCreateCheckbox("Stata 9 Class Packages",530,320)  ;Checkbox 39
$APP40_CHKBOX = GUICtrlCreateCheckbox("Stata 11",530,340)  ;Checkbox 40
$APP41_CHKBOX = GUICtrlCreateCheckbox("Stata 12",530,360)  ;Checkbox 41
$APP42_CHKBOX = GUICtrlCreateCheckbox("Systat 13",530,380)  ;Checkbox 42
$APP43_CHKBOX = GUICtrlCreateCheckbox("WinEdt 5.5",530,400)  ;Checkbox 43
$APP44_CHKBOX = GUICtrlCreateCheckbox("WinShell 3.3.2",530,420)  ;Checkbox 44
$APP45_CHKBOX = GUICtrlCreateCheckbox("WordPerfect Office X3",530,440)  ;Checkbox 45
$APP46_CHKBOX = GUICtrlCreateCheckbox("WOT (for IE)",530,460)  ;Checkbox 46
$APP47_CHKBOX = GUICtrlCreateCheckbox("zTree",530,480)  ;Checkbox 47

$RUN = GUICtrlCreateButton("Install",10,520,120,20)  ;This is the Install button
$CLEAR = GUICtrlCreateButton("Clear Boxes",270,520,120,20)  ;This is the Clear Boxes button
$EXIT = GUICtrlCreateButton("Exit",530,520,120,20)  ;This causes the application to exit
GUICtrlSetTip($RUN,"Create installation batch file.")
GUICtrlSetTip($CLEAR,"Clear application check boxes.")
GUICtrlSetTip($EXIT,"Exit the application installer.")
$UAC = RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System","EnableLUA") ;read UAC registry key
If($UAC == 1) Then ;Show whether UAC is on or not
	GUICtrlCreateLabel("!!! UAC is on !!!",155,520) ;UAC is On
Else
	GUICtrlCreateLabel("UAC is off",155,520) ;UAC is Off
EndIf
GUISetState()

Do
$msg = GUIGetMsg()

;check for commandline parameters
If $CmdLine[0] > 0 Then
	If $CmdLine[1] == "pal" Then
		$statuspal = 1
	EndIf
	If $CmdLine[1] == "exp" Then
		$statusexperimental = 1
	EndIf
	If $CmdLine[1] == "grad" Then
		$statusgrad = 1
	EndIf
	If $CmdLine[1] == "125" Then
		$status125 = 1
	EndIf
	If $CmdLine[1] == "standard" Then
		$statusstandardinstall = 1
	EndIf
EndIf

;see if any install types have changed
If $statusstandardinstall <> $standardprevchecked OR $statuscurrentupdate <> $currentprevchecked OR $statusexperimental <> $experimentalprevchecked OR $statuspal <> $palprevchecked  OR $status125 <> $125prevchecked OR $statusgrad <> $gradprevchecked Then
  call("Recheck_Boxes")
EndIf

;Reads the status of the Checkboxes and sets a variable to either 1 for checked or 4 for not checked
;This HAS to be included before the UNTIL statement
$status0 = GUICtrlRead($APP0_CHKBOX)
$status1 = GUICtrlRead($APP1_CHKBOX)
$status2 = GUICtrlRead($APP2_CHKBOX)
$status3 = GUICtrlRead($APP3_CHKBOX)
$status4 = GUICtrlRead($APP4_CHKBOX)
$status5 = GUICtrlRead($APP5_CHKBOX)
$status6 = GUICtrlRead($APP6_CHKBOX)
$status7 = GUICtrlRead($APP7_CHKBOX)
$status8 = GUICtrlRead($APP8_CHKBOX)
$status9 = GUICtrlRead($APP9_CHKBOX)
$status10 = GUICtrlRead($APP10_CHKBOX)
$status11 = GUICtrlRead($APP11_CHKBOX)
$status12 = GUICtrlRead($APP12_CHKBOX)
$status13 = GUICtrlRead($APP13_CHKBOX)
$status14 = GUICtrlRead($APP14_CHKBOX)
$status15 = GUICtrlRead($APP15_CHKBOX)
$status16 = GUICtrlRead($APP16_CHKBOX)
$status17 = GUICtrlRead($APP17_CHKBOX)
$status18 = GUICtrlRead($APP18_CHKBOX)
$status19 = GUICtrlRead($APP19_CHKBOX)
$status20 = GUICtrlRead($APP20_CHKBOX)
$status21 = GUICtrlRead($APP21_CHKBOX)
$status22 = GUICtrlRead($APP22_CHKBOX)
$status23 = GUICtrlRead($APP23_CHKBOX)
$status24 = GUICtrlRead($APP24_CHKBOX)
$status25 = GUICtrlRead($APP25_CHKBOX)
$status26 = GUICtrlRead($APP26_CHKBOX)
$status27 = GUICtrlRead($APP27_CHKBOX)
$status28 = GUICtrlRead($APP28_CHKBOX)
$status29 = GUICtrlRead($APP29_CHKBOX)
$status30 = GUICtrlRead($APP30_CHKBOX)
$status31 = GUICtrlRead($APP31_CHKBOX)
$status32 = GUICtrlRead($APP32_CHKBOX)
$status33 = GUICtrlRead($APP33_CHKBOX)
$status34 = GUICtrlRead($APP34_CHKBOX)
$status35 = GUICtrlRead($APP35_CHKBOX)
$status36 = GUICtrlRead($APP36_CHKBOX)
$status37 = GUICtrlRead($APP37_CHKBOX)
$status38 = GUICtrlRead($APP38_CHKBOX)
$status39 = GUICtrlRead($APP39_CHKBOX)
$status40 = GUICtrlRead($APP40_CHKBOX)
$status41 = GUICtrlRead($APP41_CHKBOX)
$status42 = GUICtrlRead($APP42_CHKBOX)
$status43 = GUICtrlRead($APP43_CHKBOX)
$status44 = GUICtrlRead($APP44_CHKBOX)
$status45 = GUICtrlRead($APP45_CHKBOX)
$status46 = GUICtrlRead($APP46_CHKBOX)
$status47 = GUICtrlRead($APP47_CHKBOX)
$statusstandardinstall = GUICtrlRead($STANDARDINSTALL)
$statuscurrentupdate = GUICtrlRead($CURRENTUPDATE)
$statusexperimental = GUICtrlRead($EXPERIMENTALLAB)
$statuspal = GUICtrlRead($PAL)
$statusrestart = GUICtrlRead($RESTART)
$status125 = GUICtrlRead($125)
$statusgrad = GUICtrlRead($GRADOFFICE)
$statusmsupdate = GUICtrlRead($MSUPDATE)

If $msg = $CLEAR Then
	call ("Clear")
EndIf
; close if X button pressed
If $msg = $GUI_EVENT_CLOSE Then
  Exit
EndIf
; if commandline option used, run automatically
If $CmdLine[0] > 0 Then
	$msg = $RUN
EndIf
Until $msg = $EXIT or $msg = $RUN
If $msg = $EXIT then Exit

$TMPDIR = EnvGet ("TEMP")
FileCopy("\\server\share\autoit\menu_install.bat",@DesktopDir,9)
FileCopy("\\server\share\autoit\AppList.au3",@DesktopDir,9)
FileCopy("\\server\share\autoit\autoit3.exe",$TMPDIR,9)
DirCopy("\\server\share\autoit\scripts",$TMPDIR & "\scripts",1)
$file = FileOpen(@DesktopDir & "\AppList.au3",1)

;Checks the status of the Checkboxes and calls the application function(s) if the checkbox is enabled
IF $status0 = 1 then call ("APP_0")
IF $status1 = 1 then call ("APP_1")
IF $status2 = 1 then call ("APP_2")
IF $status3 = 1 then call ("APP_3")
IF $status4 = 1 then call ("APP_4")
IF $status5 = 1 then call ("APP_5")
IF $status6 = 1 then call ("APP_6")
IF $status7 = 1 then call ("APP_7")
IF $status8 = 1 then call ("APP_8")
IF $status9 = 1 then call ("APP_9")
IF $status10 = 1 then call ("APP_10")
IF $status11 = 1 then call ("APP_11")
IF $status12 = 1 then call ("APP_12")
IF $status13 = 1 then call ("APP_13")
IF $status14 = 1 then call ("APP_14")
IF $status15 = 1 then call ("APP_15")
IF $status16 = 1 then call ("APP_16")
IF $status17 = 1 then call ("APP_17")
IF $status18 = 1 then call ("APP_18")
IF $status19 = 1 then call ("APP_19")
IF $status20 = 1 then call ("APP_20")
IF $status21 = 1 then call ("APP_21")
IF $status22 = 1 then call ("APP_22")
IF $status23 = 1 then call ("APP_23")
IF $status24 = 1 then call ("APP_24")
IF $status25 = 1 then call ("APP_25")
IF $status26 = 1 then call ("APP_26")
IF $status27 = 1 then call ("APP_27")
IF $status28 = 1 then call ("APP_28")
IF $status29 = 1 then call ("APP_29")
IF $status30 = 1 then call ("APP_30")
IF $status31 = 1 then call ("APP_31")
IF $status32 = 1 then call ("APP_32")
IF $status33 = 1 then call ("APP_33")
IF $status34 = 1 then call ("APP_34")
IF $status35 = 1 then call ("APP_35")
IF $status36 = 1 then call ("APP_36")
IF $status37 = 1 then call ("APP_37")
IF $status38 = 1 then call ("APP_38")
IF $status39 = 1 then call ("APP_39")
IF $status40 = 1 then call ("APP_40")
IF $status41 = 1 then call ("APP_41")
IF $status42 = 1 then call ("APP_42")
IF $status43 = 1 then call ("APP_43")
IF $status44 = 1 then call ("APP_44")
IF $status45 = 1 then call ("APP_45")
IF $status46 = 1 then call ("APP_46")
IF $status47 = 1 then call ("APP_47")
IF $statusmsupdate = 1 Then Call ("MSUpdate")
IF $statusrestart = 1 Then Call ("Restart")
Call ("END_APP")

;Add Application Functions here
Func APP_0() ;Function for application 0
  FileWriteLine($file,"_RunAU3('DotNet2.0.au3')")
EndFunc

Func APP_1() ;Function for application 1
  FileWriteLine($file,"_RunAU3('DotNet3.5sp1.au3')")
EndFunc

Func APP_2() ;Function for application 2
  FileWriteLine($file,"_RunAU3('Acrobat_10.au3')")
EndFunc

Func APP_3() ;Function for application 3
  FileWriteLine($file,"_RunAU3('RemoveAdobeReader.au3')")
EndFunc

Func APP_4() ;Function for application 4
  FileWriteLine($file,"_RunAU3('Amos_20.au3')")
EndFunc

Func APP_5() ;Function for application 5
  FileWriteLine($file,"_RunAU3('DellPowerDVD9.5.au3')")
EndFunc

Func APP_6() ;Function for application 6
  FileWriteLine($file,"_RunAU3('DirectRT2008.au3')")
EndFunc

Func APP_7() ;Function for application 7
  FileWriteLine($file,"_RunAU3('EUGene.au3')")
EndFunc

Func APP_8() ;Function for application 8
  FileWriteLine($file,"_RunAU3('FileZilla_3.5.3.au3')")
EndFunc

Func APP_9() ;Function for application 9
  FileWriteLine($file,"_RunAU3('Firefox_15.0.1.au3')")
EndFunc

Func APP_10() ;Function for application 10
  FileWriteLine($file,"_RunAU3('HLM7.au3')")
EndFunc

Func APP_11() ;Function for application 11
  FileWriteLine($file,"_RunAU3('IE9.au3')")
EndFunc

Func APP_12() ;Function for application 12
  FileWriteLine($file,"_RunAU3('iTunes_10.7.au3')")
EndFunc

Func APP_13() ;Function for application 13
  FileWriteLine($file,"_RunAU3('Java_7_7.au3')")
EndFunc

Func APP_14() ;Function for application 14
  FileWriteLine($file,"_RunAU3('LANDeskAgent.au3')")
EndFunc

Func APP_15() ;Function for application 15
  FileWriteLine($file,"_RunAU3('McAfee_VirusScan_8.8.au3')")
EndFunc

Func APP_16() ;Function for application 16
  FileWriteLine($file,"_RunAU3('MediaLab08.1.33.au3')")
EndFunc

Func APP_17() ;Function for application 17
  FileWriteLine($file,"_RunAU3('Forefront2010.au3')")
EndFunc

Func APP_18() ;Function for application 18
  FileWriteLine($file,"_RunAU3('Forefront2012.au3')")
EndFunc

Func APP_19() ;Function for application 19
  FileWriteLine($file,"_RunAU3('Microsoft_FrontPage_2003.au3')")
EndFunc

Func APP_20() ;Function for application 20
  FileWriteLine($file,"_RunAU3('Microsoft_Office_2003.au3')")
EndFunc

Func APP_21() ;Function for application 21
  FileWriteLine($file,"_RunAU3('Microsoft_Office_2003_SP3.au3')")
EndFunc

Func APP_22() ;Function for application 22
  FileWriteLine($file,"_RunAU3('Office2003FileConverter.au3')")
EndFunc

Func APP_23() ;Function for application 23
  FileWriteLine($file,"_RunAU3('Microsoft_Office_2007.au3')")
EndFunc

Func APP_24() ;Function for application 24
  FileWriteLine($file,"_RunAU3('Microsoft_Office_2007_SP2.au3')")
EndFunc

Func APP_25() ;Function for application 25
  FileWriteLine($file,"_RunAU3('Microsoft_Office_2010.au3')")
EndFunc

Func APP_26() ;Function for application 26
  FileWriteLine($file,"_RunAU3('Microsoft_Office_2010_SP1.au3')")
EndFunc

Func APP_27() ;Function for application 27
  FileWriteLine($file,"_RunAU3('Miktex_2.9.au3')")
EndFunc

Func APP_28() ;Function for application 28
  FileWriteLine($file,"_RunAU3('PaintDotNet_3.5.10.au3')")
EndFunc

Func APP_29() ;Function for application 29
  FileWriteLine($file,"_RunAU3('QuickTime_7.7.2.au3')")
EndFunc

Func APP_30() ;Function for application 30
  FileWriteLine($file,"_RunAU3('R_2.15.0.au3')")
EndFunc

Func APP_31() ;Function for application 31
  FileWriteLine($file,"_RunAU3('R_uninstall.au3')")
EndFunc

Func APP_32() ;Function for application 32
  FileWriteLine($file,"_RunAU3('RStudio_0.96.au3')")
EndFunc

Func APP_33() ;Function for application 33
  FileWriteLine($file,"_RunAU3('Roxio10.au3')")
EndFunc

Func APP_34() ;Function for application 34
  FileWriteLine($file,"_RunAU3('SPSS14-19AuthUpdate.au3')")
EndFunc

Func APP_35() ;Function for application 35
  FileWriteLine($file,"_RunAU3('SPSS18_shortcutdelete.au3')")
EndFunc

Func APP_36() ;Function for application 36
  FileWriteLine($file,"_RunAU3('SPSS20.au3')")
EndFunc

Func APP_37() ;Function for application 37
  FileWriteLine($file,"_RunAU3('Stata9.au3')")
EndFunc

Func APP_38() ;Function for application 38
  FileWriteLine($file,"_RunAU3('Stata9_2.au3')")
EndFunc

Func APP_39() ;Function for application 39
  FileWriteLine($file,"_RunAU3('Stata9_packages.au3')")
EndFunc

Func APP_40() ;Function for application 40
  FileWriteLine($file,"_RunAU3('Stata11.au3')")
EndFunc

Func APP_41() ;Function for application 41
  FileWriteLine($file,"_RunAU3('Stata12.au3')")
EndFunc

Func APP_42() ;Function for application 42
  FileWriteLine($file,"_RunAU3('Systat13.au3')")
EndFunc

Func APP_43() ;Function for application 43
  FileWriteLine($file,"_RunAU3('WinEdt_5.5.au3')")
EndFunc

Func APP_44() ;Function for application 44
  FileWriteLine($file,"_RunAU3('WinShell_3.3.2.au3')")
EndFunc

Func APP_45() ;Function for application 45
  FileWriteLine($file,"_RunAU3('WordPerfect_Office_X3.au3')")
EndFunc

Func APP_46() ;Function for application 46
  FileWriteLine($file,"_RunAU3('WebofTrust.au3')")
EndFunc

Func APP_47() ;Function for application 47
  FileWriteLine($file,"_RunAU3('zTree.au3')")
EndFunc

Func Recheck_Boxes()

	;keep old values
	$restart_temp = $statusrestart
	$standard_temp = $statusstandardinstall
	$current_temp = $statuscurrentupdate 
	$experimental_temp = $statusexperimental 
	$pal_temp = $statuspal  
	$125_temp = $status125 
	$grad_temp = $statusgrad

	;clear previous selections
	call("Clear")
	;set MS Updates
	call("SetMSUpdate")

	;recheck types if checked
	If $standard_temp == $GUI_CHECKED Then
		GUICtrlSetState(8,$GUI_CHECKED)
		call("StandardInstall")
		$standardprevchecked = $GUI_CHECKED
	Else
		$standardprevchecked = $GUI_UNCHECKED
	EndIf

	If $current_temp == $GUI_CHECKED Then
		GUICtrlSetState(13,$GUI_CHECKED)
		call("CurrentUpdate")
		$currentprevchecked = $GUI_CHECKED
	Else
		$currentprevchecked = $GUI_UNCHECKED
	EndIf

	If $experimental_temp = $GUI_CHECKED Then
		GUICtrlSetState(10,$GUI_CHECKED)
		call("ExperimentalLab")
		$experimentalprevchecked = $GUI_CHECKED
	Else
		$experimentalprevchecked = $GUI_UNCHECKED
	EndIf

	If $pal_temp = $GUI_CHECKED Then
		GUICtrlSetState(11,$GUI_CHECKED)
		call("PAL")
		$palprevchecked = $GUI_CHECKED
	Else
		$palprevchecked = $GUI_UNCHECKED
	EndIf

	If $125_temp = $GUI_CHECKED Then
		GUICtrlSetState(9,$GUI_CHECKED)
		call("Box125")
		$125prevchecked = $GUI_CHECKED
	Else
		$125prevchecked = $GUI_UNCHECKED
	EndIf

	If $grad_temp = $GUI_CHECKED Then
		GUICtrlSetState(14,$GUI_CHECKED)
		call("GradOffice")
		$gradprevchecked = $GUI_CHECKED
	Else
		$gradprevchecked = $GUI_UNCHECKED
	EndIf

	If $restart_temp = $GUI_CHECKED Then
		GUICtrlSetState(12,$GUI_CHECKED)
	EndIf

EndFunc

Func StandardInstall(); Function for standard install checkbox
	GUICtrlSetState (18, $GUI_CHECKED)
	GUICtrlSetState (25, $GUI_CHECKED)
	GUICtrlSetState (27, $GUI_CHECKED)
	GUICtrlSetState (29, $GUI_CHECKED)
	GUICtrlSetState (34, $GUI_CHECKED)
	GUICtrlSetState (41, $GUI_CHECKED)
	GUICtrlSetState (42, $GUI_CHECKED)
	GUICtrlSetState (45, $GUI_CHECKED)
	GUICtrlSetState (62, $GUI_CHECKED)
EndFunc
Func CurrentUpdate(); Function for current update checkbox
	GUICtrlSetState (18, $GUI_CHECKED)
	GUICtrlSetState (25, $GUI_CHECKED)
	GUICtrlSetState (27, $GUI_CHECKED)
	GUICtrlSetState (29, $GUI_CHECKED)
	GUICtrlSetState (31, $GUI_CHECKED)
	GUICtrlSetState (41, $GUI_CHECKED)
	GUICtrlSetState (43, $GUI_CHECKED)
	GUICtrlSetState (45, $GUI_CHECKED)
	GUICtrlSetState (46, $GUI_CHECKED)
	GUICtrlSetState (49, $GUI_CHECKED)
	GUICtrlSetState (52, $GUI_CHECKED)
EndFunc
Func ExperimentalLab(); Function for experimental lab checkbox
	GUICtrlSetState (18, $GUI_CHECKED)
	GUICtrlSetState (22, $GUI_CHECKED)
	GUICtrlSetState (25, $GUI_CHECKED)
	GUICtrlSetState (27, $GUI_CHECKED)
	GUICtrlSetState (29, $GUI_CHECKED)
	GUICtrlSetState (30, $GUI_CHECKED)
	GUICtrlSetState (32, $GUI_CHECKED)
	GUICtrlSetState (34, $GUI_CHECKED)
	GUICtrlSetState (41, $GUI_CHECKED)
	GUICtrlSetState (42, $GUI_CHECKED)
	GUICtrlSetState (43, $GUI_CHECKED)
	GUICtrlSetState (45, $GUI_CHECKED)
	GUICtrlSetState (46, $GUI_CHECKED)
	GUICtrlSetState (47, $GUI_CHECKED)
	GUICtrlSetState (49, $GUI_CHECKED)
	GUICtrlSetState (52, $GUI_CHECKED)
	GUICtrlSetState (56, $GUI_CHECKED)
	GUICtrlSetState (60, $GUI_CHECKED)
	GUICtrlSetState (63, $GUI_CHECKED)
EndFunc
Func PAL(); Function for pal checkbox
	GUICtrlSetState (18, $GUI_CHECKED)
	GUICtrlSetState (25, $GUI_CHECKED)
	GUICtrlSetState (26, $GUI_CHECKED)
	GUICtrlSetState (27, $GUI_CHECKED)
	GUICtrlSetState (29, $GUI_CHECKED)
	GUICtrlSetState (30, $GUI_CHECKED)
	GUICtrlSetState (34, $GUI_CHECKED)
	GUICtrlSetState (41, $GUI_CHECKED)
	GUICtrlSetState (42, $GUI_CHECKED)
	GUICtrlSetState (43, $GUI_CHECKED)
	GUICtrlSetState (45, $GUI_CHECKED)
	GUICtrlSetState (46, $GUI_CHECKED)
	GUICtrlSetState (47, $GUI_CHECKED)
	GUICtrlSetState (49, $GUI_CHECKED)
	GUICtrlSetState (52, $GUI_CHECKED)
	GUICtrlSetState (57, $GUI_CHECKED)
EndFunc
Func Box125(); Function for 125/150 lab checkbox
	GUICtrlSetState (18, $GUI_CHECKED)
	GUICtrlSetState (25, $GUI_CHECKED)
	GUICtrlSetState (28, $GUI_CHECKED)
	GUICtrlSetState (29, $GUI_CHECKED)
	GUICtrlSetState (30, $GUI_CHECKED)
	GUICtrlSetState (34, $GUI_CHECKED)
	GUICtrlSetState (41, $GUI_CHECKED)
	GUICtrlSetState (42, $GUI_CHECKED)
	GUICtrlSetState (43, $GUI_CHECKED)
	GUICtrlSetState (45, $GUI_CHECKED)
	GUICtrlSetState (46, $GUI_CHECKED)
	GUICtrlSetState (47, $GUI_CHECKED)
	GUICtrlSetState (48, $GUI_CHECKED)
	GUICtrlSetState (49, $GUI_CHECKED)
	GUICtrlSetState (50, $GUI_CHECKED)
	GUICtrlSetState (51, $GUI_CHECKED)
	GUICtrlSetState (57, $GUI_CHECKED)
	GUICtrlSetState (60, $GUI_CHECKED)
EndFunc
Func GradOffice(); Function for grad office checkbox
	GUICtrlSetState (18, $GUI_CHECKED)
	GUICtrlSetState (25, $GUI_CHECKED)
	GUICtrlSetState (27, $GUI_CHECKED)
	GUICtrlSetState (29, $GUI_CHECKED)
	GUICtrlSetState (30, $GUI_CHECKED)
	GUICtrlSetState (34, $GUI_CHECKED)
	GUICtrlSetState (41, $GUI_CHECKED)
	GUICtrlSetState (42, $GUI_CHECKED)
	GUICtrlSetState (45, $GUI_CHECKED)
	GUICtrlSetState (46, $GUI_CHECKED)
	GUICtrlSetState (49, $GUI_CHECKED)
	GUICtrlSetState (52, $GUI_CHECKED)
	GUICtrlSetState (53, $GUI_CHECKED)
	GUICtrlSetState (54, $GUI_CHECKED)
EndFunc
Func Clear()
  ;clear all check boxes
  For $i = 11 to 63
    GUICtrlSetState ($i, $GUI_UNCHECKED)
  Next
EndFunc

Func SetMSUpdate()
  GUICtrlSetState(15, $GUI_CHECKED)
EndFunc

Func MSUpdate()
  FileWriteLine($file,"_RunAU3('msupdates_optin.au3')")
EndFunc

Func Restart()
  FileWriteLine($file,"Sleep(1000)")
  FileWriteLine($file,"Run(@ComSpec & "" /k shutdown -r -c """"Restart for software installation"""" -d p:04:02"")")
EndFunc

Func END_APP()
  MsgBox(4096,"Complete","Custom software list created for selected applications. Run 'menu_install.bat' from the Desktop.",2)
EndFunc
