;===============================================================================
;
; Description:      McAfee VirusScan 8.8 Installer
; Syntax:           McAfee_VirusScan_8.8.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs McAfee VirusScan & Updates definitions
;                   This script will remove McAfee VirusScan 8.0, 8.5, 8.7 if present, preserving settings
; Last Modified:    2/23/11
;
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "McAfee VirusScan 8.7"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\McAfee\VirusScan Enterprise\scan32.exe"
Else
	$AppBinFile = "C:\Program Files\McAfee\VirusScan Enterprise\scan32.exe"
EndIf
;The expected file version.
$AppBinFileVersion = "8.8.0.777"
;The installation source directory
$SourceDir = "\\server\share\applications\mcafee virusscan 8.8"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "Setup.exe",@WindowsDir )

	; check if previous or first time install
	 AdlibRegister("_Previous")

	WinWait ( "McAfee VirusScan Enterprise Setup","McAfee VirusScan Enterprise")
	ControlClick("McAfee VirusScan Enterprise Setup","McAfee VirusScan Enterprise","&Next >")

	AutoItSetOption ( "MouseCoordMode", 0 )
	WinWait ("McAfee Licensing","McAfee End User License Agreement")
	; change to perpetual
	MouseClick($primary, 246, 138, 1, 1)
	MouseClick($primary, 223, 179, 1)
	ControlClick("McAfee Licensing","McAfee End User License Agreement","I &accept the terms in the license agreement")
	ControlClick("McAfee Licensing","McAfee End User License Agreement","OK")

	WinWait ("McAfee VirusScan Enterprise Setup","Select Setup Type")
	ControlClick("McAfee VirusScan Enterprise Setup","Select Setup Type","&Next >")

	WinWait ("McAfee VirusScan Enterprise Setup","Ready to install")
	ControlClick("McAfee VirusScan Enterprise Setup","Ready to install","&Install")

	WinWait ( "McAfee VirusScan Enterprise Setup","McAfee VirusScan Enterprise setup has completed")
	ControlCommand("McAfee VirusScan Enterprise Setup","McAfee VirusScan Enterprise setup has completed","Button1","Check","")
	ControlCommand("McAfee VirusScan Enterprise Setup","McAfee VirusScan Enterprise setup has completed","Button2","UnCheck","")
	ControlClick("McAfee VirusScan Enterprise Setup","McAfee VirusScan Enterprise setup has completed","&Finish")

	 AdlibUnRegister()

	WinWait("McAfee Agent Updater","Update in Progress")
	While WinExists("McAfee Agent Updater","Update in Progress")
		Sleep(500)
	WEnd

	WinWait("McAfee VirusScan Enterprise Setup","The network driver")
	ControlClick("McAfee VirusScan Enterprise Setup","The network driver","OK")


	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func _Previous()
	If WinExists("VirusScan Setup","Windows Defender") Then
		ControlClick("VirusScan Setup","Windows Defender","&No")
	EndIf

	If WinExists("Windows Installer","Another version") Then
		ControlClick("Windows Installer","Another version","OK")

		;remove 8.7.0 or 8.7.1
		$uninstallproc = Run ("msiexec /x {147BCE03-C0F1-4C9F-8157-6A89B6D2D973} REMOVE=ALL REBOOT=R /q")

		;wait while uninstall process runs
		ProcessWaitClose($uninstallproc)

		;run setup again to install
		Run ( $TMPDIR & "\" & $AppName & "\" & "SETUP.EXE",@WindowsDir )
	EndIf

	If WinExists("McAfee VirusScan Enterprise Setup","Previous Version Detected") Then
	  ControlClick("McAfee VirusScan Enterprise Setup","Previous Version Detected","&Next >")
	EndIf

	If WinExists("McAfee VirusScan Enterprise Setup","Select Access Protection Level") Then
	  ControlClick("McAfee VirusScan Enterprise Setup","Select Access Protection Level","&Next >")
	EndIf

	;close /silent flag error window
	If WinExists("McAfee Agent and Updater Setup","Unexpected value") Then
		ControlClick("Mcafee Agent and Updater Setup","Unexpected value","OK")
		Send("{ENTER}")
	EndIf
EndFunc
