;===============================================================================
;
; Description:      Java Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs Java
; Last Modified:    9/17/12
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Java"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Java\jre7\bin\java.exe"
Else
	$AppBinFile = "C:\Program Files\Java\jre7\bin\java.exe"
EndIf

;The expected file version.
$AppBinFileVersion = "7.0.70.11"
;The installation source directory
$SourceDir = "\\server\share\applications\java\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "java7_7_32bit.exe",@WindowsDir )

	WinWait ( "Java Setup - Welcome","Welcome" )
	ControlClick ( "Java Setup - Welcome", "Welcome", "&Install >" )

	AdlibRegister("_JavaGoogle")

	WinWait ( "Java Setup - Complete","You have successfully" )
	ControlClick ( "Java Setup - Complete","You have successfully", "&Close" )

	 AdlibUnRegister()

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func _JavaGoogle()
	If WinExists("Java Setup - Google","Google Toolbar") Then
		ControlCommand("Java Setup - Google","Google Toolbar","Button2","UnCheck","")
		ControlClick("Java Setup - Google","Google Toolbar","&Next >")
	EndIf

	If WinExists("Java Setup - Yahoo","Yahoo! Toolbar") Then
		ControlCommand("Java Setup - Yahoo","Yahoo! Toolbar","Button2","UnCheck","")
		ControlClick("Java Setup - Yahoo","Yahoo! Toolbar","&Next >")
	EndIf

	If WinExists("Java Setup - OpenOffice","OpenOffice") Then
		ControlCommand("Java Setup - OpenOffice","OpenOffice","Button2","UnCheck","")
		ControlClick("Java Setup - OpenOffice","OpenOffice","&Next >")
	EndIf

	If WinExists("Java Setup - Puzzle Pirates","Puzzle") Then
		ControlCommand("Java Setup - Puzzle Pirates","Puzzle","Button2","UnCheck","")
		ControlClick("Java Setup - Puzzle Pirates","Puzzle","&Next >")
	EndIf

	If WinExists("Java Setup - MSN Toolbar","Toolbar") Then
		ControlCommand("Java Setup - MSN Toolbar","Toolbar","Button2","UnCheck","")
		ControlClick("Java Setup - MSN Toolbar","Toolbar","&Next >")
	EndIf

	If WinExists("Java Setup - Bing Toolbar","Toolbar") Then
		ControlCommand("Java Setup - Bing Toolbar","Toolbar","Button3","UnCheck","")
		ControlClick("Java Setup - Bing Toolbar","Toolbar","Next >")
	EndIf

	If WinExists("Java Setup - Security Scan","Security") Then
		ControlCommand("Java Setup - Security Scan","Security","Button3","UnCheck","")
		ControlClick("Java Setup - Security Scan","Security","Next >")
	EndIf
	
	If WinExists("Java Setup - Ask Toolbar","Toolbar") Then
		ControlCommand("Java Setup - Ask Toolbar","Toolbar","Button3","UnCheck","")
		ControlClick("Java Setup - Ask Toolbar","Toolbar","Next >")
	EndIf

EndFunc
