

func _DownloadWithProgress($SourceDir, $TMPDIR, $AppName)
	
	;overwrite function is not automatic, delete dest files if they exist
	If FileExists ($TMPDIR & "\" & $AppName) Then
		DirRemove($TMPDIR & "\" & $AppName,1)
	EndIf
	
	;create the directory for file copy
	DirCreate ( $TMPDIR & "\" & $AppName )
	
	;copy files with windows progress bar
	_FileCopy($SourceDir & "\*.*", $TMPDIR & "\" & $AppName)
	
	;Note: to download the directory directly with file overwrite (and no progress bar)
	;comment out all of the previous lines of this function except DirCreate and uncomment the following line
	;DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
EndFunc

;file copy with progress bar
func _FileCopy($fromFile,$tofile)
	;copy files
	Local $FOF_RESPOND_YES = 16
    Local $FOF_SIMPLEPROGRESS = 256
    $winShell = ObjCreate("shell.application")
    $winShell.namespace($tofile).CopyHere($fromFile,$FOF_RESPOND_YES)
EndFunc