;===============================================================================
;
; Description:      IE 9 Installer
; Syntax:           IE9.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Josh Morris
; Note(s):          This script installs IE 9 on Windows 7
; Last Modified:    3/30/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "IE9"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Internet Explorer\iexplore.exe"
;The expected file version.
$AppBinFileVersion = "9.0.8112.16421"



;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if not @OSVersion == "WIN_7" and not @OSVersion == "WIN_VISTA" then
	MsgBox(0,"Windows Version","This version of IE 9 is designed for Windows 7 & Windows Vista. A different OS version has been detected.",10)
Else

	if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

		_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
		_FileWriteLog($LogFile, "Launching Setup now...")
		
		if @OSVersion == "WIN_7" Then
			;The installation source directory
			$SourceDir = "\\server\share\applications\ie9 win7"
			
			;download installation files with progress bar
			_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

			If @OSArch == "X64" Then
				Run ($TMPDIR & "\" & $AppName & "\" & "IE9-Windows7-x64-enu.exe",@WindowsDir )
			Else
				Run ($TMPDIR & "\" & $AppName & "\" & "IE9-Windows7-x86-enu.exe",@WindowsDir )
			EndIf
		Else
			;The installation source directory
			$SourceDir = "\\server\share\applications\ie9 vista"
			
			;download installation files with progress bar
			_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

			Run ($TMPDIR & "\" & $AppName & "\" & "IE9-WindowsVista-x86-enu.exe",@WindowsDir )
		EndIf
		

		WinWait("Windows Internet Explorer","Install")
		ControlClick("Windows Internet Explorer","Install","&Install")
		
		While WinExists("Windows Internet Explorer")
			sleep(500)
			
			if WinExists("Windows Internet Explorer","Restart &later") then
				ControlClick("Windows Internet Explorer","Restart &later","Restart &later")
				ExitLoop
			EndIf

			if WinExists("Windows Internet Explorer","OK") Then
				ControlClick("Windows Internet Explorer","OK","OK")
				ExitLoop
			EndIf
			
		WEnd
		
		
		;Re-check the version after install.
		$CurrentVer = FileGetVersion ( $AppBinFile )
		_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
		_FileWriteLog($LogFile, $AppName & " setup is now finished.")

	Else
		;The correct version must be installed.
		_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
	EndIf

EndIf ;OS Version check

