;===============================================================================
;
; Description:      Internet Explorer 8.0 Installer
; Syntax:           IE8.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs Internet Explorer 8
; Last Modified:    4/2/08
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "IE8"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Internet Explorer\iexplore.exe"
;The expected file version.
$AppBinFileVersion = "8.0.6001.18702"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")
	
	;Determine OS
	If @OSVersion == "WIN_VISTA" Then
		
		;The installation source directory
		$SourceDir = "\\server\share\applications\ie 8 vista\"
		
		;Download the files to a temp directory and start the setup.
		DirCreate ( $TMPDIR & "\" & $AppName )
		DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
		Run ( $TMPDIR & "\" & $AppName & "\" & "IE8-WindowsVista-x86-enu.exe",@WindowsDir )
		
	Else
		
		;The installation source directory
		$SourceDir = "\\server\share\applications\ie 8 xp\"
		
		;Download the files to a temp directory and start the setup.
		DirCreate ( $TMPDIR & "\" & $AppName )
		DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
		Run ( $TMPDIR & "\" & $AppName & "\" & "IE8-WindowsXP-x86-enu.exe",@WindowsDir )
		
	EndIf	
	
	WinWait("Install Windows Internet Explorer","Welcome to Windows Internet Explorer 8")
	ControlClick("Install Windows Internet Explorer","Welcome to Windows Internet Explorer 8","&Install >")
	
	WinWait("Install Windows Internet Explorer","Please read the license terms")
	ControlClick("Install Windows Internet Explorer","Please read the license terms","&Install >")
	
	AdlibEnable ("CheckForWindows")
	
	WinWait("Install Windows Internet Explorer","Get the latest updates")
	ControlClick("Install Windows Internet Explorer","Get the latest updates","&Install >")
	
	WinWait("Install Windows Internet Explorer","Internet Explorer installation is complete")
	ControlClick("Install Windows Internet Explorer","Internet Explorer installation is complete","Restart &later")
	
	;it is strong recommended to restart
	WinWait("Install Windows Internet Explorer","&Yes")
	ControlClick("Install Windows Internet Explorer","&Yes","&Yes")
	
	Sleep(1500)
	
	AdlibDisable ( )
	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

func CheckForWindows()
	If WinExists("Install Windows Internet Explorer","Validate your copy of Windows") Then
		ControlClick("Install Windows Internet Explorer","Validate your copy of Windows","&Install >")
	EndIf
	
	If WinExists("Install Windows Internet Explorer","You have chosen to exit Setup") Then
		ControlClick("Install Windows Internet Explorer","You have chosen to exit Setup","OK")
	EndIf
EndFunc

