;===============================================================================
;
; Description:      Internet Explorer 7.0 Installer
; Syntax:           IE7.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs Internet Explorer 7
; Last Modified:    12/12/06
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "IE7"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Internet Explorer\iexplore.exe"
;The expected file version.
$AppBinFileVersion = "7.0.5730.11"
;The installation source directory
$SourceDir = "\\server\share\software\ie 7\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ( $TMPDIR & "\" & $AppName & "\" & "IE7-WindowsXP-x86-enu.exe",@WindowsDir )
	
	WinWait("Install Windows Internet Explorer","Welcome to Windows Internet Explorer 7")
	ControlClick("Install Windows Internet Explorer","Welcome to Windows Internet Explorer 7","&Install >")
	
	WinWait("Install Windows Internet Explorer","Please read the license terms")
	ControlClick("Install Windows Internet Explorer","Please read the license terms","&Install >")
	
	WinWait("Install Windows Internet Explorer","Validate your copy of Windows")
	ControlClick("Install Windows Internet Explorer","Validate your copy of Windows","&Install >")
	
	WinWait("Install Windows Internet Explorer","Get the latest updates")
	ControlClick("Install Windows Internet Explorer","Get the latest updates","&Install >")
	
	WinWait("Install Windows Internet Explorer","Internet Explorer installation is complete")
	ControlClick("Install Windows Internet Explorer","Internet Explorer installation is complete","Restart &Later")
	
	WinWait("Install Windows Internet Explorer","It is strongly recommended")
	ControlClick("Install Windows Internet Explorer","It is strongly recommended","&Yes")
	
	WinWait("Install Windows Internet Explorer","You have chosen to exit Setup")
	ControlClick("Install Windows Internet Explorer","You have chosen to exit Setup","OK")
	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

