;===============================================================================
;
; Description:      Microsoft Forefront Installer
; Syntax:           Forefront2010.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Josh Morris
; Note(s):          This script installs MS Forefront security software
; Last Modified:    5/18/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Forefront"
;The binary file whose version we will check.
$AppBinFile = "C:\Program Files\Microsoft Security Client\setup.exe"

;The expected file version.
$AppBinFileVersion = "2.0.657.0"
;The installation source directory
If @OSArch == "X64" Then
	$SourceDir = "\\server\share\applications\ForeFront Endpoint\FEP2010_en-us\x64"
Else
	$SourceDir = "\\server\share\applications\ForeFront Endpoint\FEP2010_en-us\x86"
EndIf

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ($TMPDIR & "\" & $AppName & "\" & "client\FEPInstall.exe",@WindowsDir )

	WinWait("Microsoft Forefront","Welcome")
	ControlClick("Microsoft Forefront","Welcome","Next >")
	
	AdlibRegister("Screens")
	
	WinWait("Microsoft Forefront","These license terms")
	ControlClick("Microsoft Forefront","These license terms","I accept")
	
	WinWait("Microsoft Forefront","Join the Customer")
	ControlCommand("Microsoft Forefront","Join the Customer","Button2","Check","")
	ControlClick("Microsoft Forefront","Join the Customer","Next >")
	
	WinWait("Microsoft Forefront","Optimize security")
	ControlCommand("Microsoft Forefront","Optimize security","Button4","Check","")
	ControlClick("Microsoft Forefront","Optimize security","Next >")
		
	WinWait("Microsoft Forefront","Completing")
	ControlClick("Microsoft Forefront","Completing","Finish")
	
	Sleep(1000)
	
	AdlibUnRegister("Screens")	

	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

func Screens()
	If WinExists("Microsoft Forefront","Ready to install") Then
		ControlClick("Microsoft Forefront","Ready to install","Install >")
	Endif
	
	If WinExists("Microsoft Forefront","If you choose") Then
		ControlClick("Microsoft Forefront","If you choose","&Yes")
	EndIf
	
	If WinExists("Microsoft Forefront","Remove other") Then
		ControlClick("Microsoft Forefront","Remove other","Remove now >")
	EndIf

EndFunc
