;===============================================================================
;
; Description:      Adobe FlashPlayer (Mozilla + IE) Installer
; Syntax:           FlashPlayer_xxx.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs FlashPlayer
; Last Modified:    12/20/11
; Note: Google Chrome will automatically update the non-IE flashplayer itself
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)
AutoItSetOption ( "MouseCoordMode", 0 )

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "FlashPlayer"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFileIE = "C:\Windows\SysWOW64\Macromed\Flash\FlashUtil11e_ActiveX.exe"
	$AppBinFileNonIE = "C:\Windows\SysWOW64\Macromed\Flash\FlashUtil11e_Plugin.exe"
Else
	$AppBinFileIE = "C:\Windows\System32\Macromed\Flash\FlashUtil11e_ActiveX.exe"
	$AppBinFileNonIE = "C:\Windows\System32\Macromed\Flash\FlashUtil11e_Plugin.exe"
EndIf

;The expected file version.
$AppBinFileVersionIE = "11.1.102.55"
$AppBinFileVersionNonIE = "11.1.102.55"
;The installation source directory
$SourceDir = "\\server\share\applications\Adobe FlashPlayer\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVerIE = FileGetVersion ($AppBinFileIE)
$CurrentVerNonIE = FileGetVersion ($AppBinFileNonIE)
_FileWriteLog($LogFile, "The current version is: " & $CurrentVerIE)

;MsgBox(0,"Test","Currentapp IE=" & $AppBinFileIE & " CurrentNonapp = " & $AppBinFileNonIE)
;MsgBox(0,"Test","Current IE=" & $CurrentVerIE & " CurrentNon = " & $CurrentVerNonIE)

if Call("VersionStringCompare",$CurrentVerIE,$AppBinFileVersionIE) or Call("VersionStringCompare",$CurrentVerNonIE,$AppBinFileVersionNonIE) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)
	
	if Call("VersionStringCompare",$CurrentVerNonIE,$AppBinFileVersionNonIE) Then
		
		MsgBox(0,"Install","Running flashplayer for Firefox",2)

		Run ( $TMPDIR & "\" & $AppName & "\" & "install_flash_player_11.1.102.55.exe",@WindowsDir )

		WinWait("Adobe Flash Player","I have read")
		ControlCommand("Adobe Flash Player","I have read","Button4","Check","")
		ControlClick("Adobe Flash Player","I have read","INSTALL")

		While WinExists("Adobe Flash Player","")
			Sleep(2000)
			WinActivate("Adobe Flash Player","")
			Send("{TAB}{ENTER}")
		WEnd
	EndIf
	
	if Call("VersionStringCompare",$CurrentVerIE,$AppBinFileVersionIE) Then
		
		MsgBox(0,"Install","Running flashplayer for IE",2)
		
		Run ( $TMPDIR & "\" & $AppName & "\" & "install_flash_player_11.1.102.55_ie.exe",@WindowsDir )

		WinWait("Adobe Flash Player","I have read")
		ControlCommand("Adobe Flash Player","I have read","Button4","Check","")
		ControlClick("Adobe Flash Player","I have read","INSTALL")

		While WinExists("Adobe Flash Player","")
			Sleep(2000)
			WinActivate("Adobe Flash Player","")
			Send("{TAB}{ENTER}") ;MouseClick($primary, 61, 18, 1)
		WEnd
	EndIf

	;Re-check the version after install.
	$CurrentVerIE = FileGetVersion ( $AppBinFileIE )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVerIE)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf
