;===============================================================================
;
; Description:      Firefox Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs Firefox
; Last Modified:    1/4/12
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Firefox"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Mozilla Firefox\firefox.exe"
Else
	$AppBinFile = "C:\Program Files\Mozilla Firefox\firefox.exe"
EndIf

;The expected file version.
$AppBinFileVersion = "9.0.1.4371"
;The installation source directory
$SourceDir = "\\server\share\applications\mozilla firefox\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	;run the installer
	Run ( $TMPDIR & "\" & $AppName & "\" & "Firefox Setup 9.0.1.exe",@WindowsDir )

	AdlibRegister ( "CheckInstallLocation")

	WinWait ( "Mozilla Firefox Setup","Welcome" )
	ControlClick ( "Mozilla Firefox Setup", "Welcome", "&Next >" )

	WinWait ( "Mozilla Firefox Setup","Setup Type" )
	ControlClick ( "Mozilla Firefox Setup","Setup Type", "&Next >" )

	WinWait("Mozilla Firefox Setup","Summary")
	ControlClick ("Mozilla Firefox Setup", "Summary", "&Install")
	ControlClick("Mozilla Firefox Setup", "Summary", "&Upgrade")

	WinWait ("Mozilla Firefox Setup","Mozilla Firefox has been installed")
	ControlClick ("Mozilla Firefox Setup", "Mozilla Firefox has been installed", "&Launch Firefox now")
	ControlClick ("Mozilla Firefox Setup", "Mozilla Firefox has been installed", "&Finish")

	AdlibUnRegister ( )

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func CheckInstallLocation()
	If  WinExists("Mozilla Firefox Setup","Choose Install Location") Then
		ControlClick("Mozilla Firefox Setup","Choose Install Location","&Next >")
	EndIf

	If WinExists ( "Mozilla Firefox Setup","License Agreement" ) Then
		ControlClick ( "Mozilla Firefox Setup","License Agreement", "Button4" )
		ControlClick ( "Mozilla Firefox Setup","License Agreement", "&Next >" )
	EndIf
EndFunc

