;===============================================================================
;
; Description:      FileZilla Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs FileZilla
; Last Modified:    8/25/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "FileZilla"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\FileZilla FTP Client\FileZilla.exe"
Else
	$AppBinFile = "C:\Program Files\FileZilla FTP Client\FileZilla.exe"
EndIf

;The expected file version.
$AppBinFileVersion = "3.5.0.0"
;The installation source directory
$SourceDir = "\\server\share\applications\filezilla\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "FileZilla_3.5.0_win32-setup.exe",@WindowsDir )


	; check if previous or first time install
	AdlibRegister("_Previous")

	WinWait("FileZilla Client","License Agreement")
	ControlClick("FileZilla Client","License Agreement","I &Agree")

	WinWait("FileZilla Client","FileZilla Client 3.5.0 has been installed")
	ControlCommand("FileZilla Client","FileZilla Client 3.5.0 has been installed","Button4","UnCheck","")
	ControlClick("FileZilla Client","FileZilla Client 3.5.0 has been installed","&Finish")

	 AdlibUnRegister()

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

Func _Previous()

	;if previous version installed perform these
	If WinExists("FileZilla Client","Already Installed") Then
		ControlClick("FileZilla Client","Already Installed","&Next >")
	EndIf
	If WinExists("FileZilla Client","Uninstall FileZilla") Then
		ControlClick("FileZilla Client","Uninstall FileZilla","&Uninstall")
	EndIf
	If WinExists("FileZilla Client","Your computer must") Then
		ControlCommand("FileZilla Client","Your computer must","Button5","Check","")
		ControlClick("FileZilla Client","Your computer must","&Finish")
	EndIf

	;if not perform these
	If WinExists("FileZilla Client","Choose Installation Options") Then
		ControlClick("FileZilla Client","Choose Installation Options","&Next >")
	EndIf

	If WinExists("FileZilla Client","Choose Components") Then
		ControlClick("FileZilla Client","Choose Components","&Next >")
	EndIf

	If WinExists("FileZilla Client","Choose Install Location") Then
		ControlClick("FileZilla Client","Choose Install Location","&Next >")
	EndIf

	If WinExists("FileZilla Client","Choose Start Menu Folder") Then
		ControlClick("FileZilla Client","Choose Start Menu Folder","&Install")
	EndIf

EndFunc
