;===============================================================================
;
; Description:      .NET Framework 3.5 SP1 Installer
; Syntax:           DotNet3.5sp1.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs .NET
; Last Modified:    2/9/10
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)
AutoItSetOption ( "MouseCoordMode", 0 )

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "DotNet3.5"
;The binary file whose version we will check.
$AppBinFile = "C:\WINDOWS\Microsoft.NET\Framework\v3.5\Microsoft .NET Framework 3.5 SP1\setup.exe"
;The expected file version.
$AppBinFileVersion = "9.0.30729.1"
;The installation source directory
$SourceDir = "\\server\share\applications\dotnet3.5sp1\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ( $TMPDIR & "\" & $AppName & "\" & "dotnetfx35.exe",@WindowsDir )

	WinWait("Microsoft .NET Framework","Welcome to Setup")
	Sleep(500)
	MouseClick($primary,23,253,1,1)
	;ControlCommand("Microsoft .NET Framework","Welcome to Setup","I have read and &ACCEPT the terms of the License Agreement","Check","")
	Sleep(500)
	MouseClick($primary,376,454,1,1)
	;ControlClick("Microsoft .NET Framework","Welcome to Setup","&Install >")

	WinWait("Microsoft .NET Framework","Setup Complete")
	ControlClick("Microsoft .NET Framework","Setup Complete","E&xit")

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

