;===============================================================================
;
; Description:      .NET Framework 2.0 Installer
; Syntax:           DotNet2.0.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris 
; Note(s):          This script installs .NET 2.0
; Last Modified:    6/15/07
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "DotNet2.0"
;The binary file whose version we will check.
$AppBinFile = "C:\WINDOWS\Microsoft.NET\Framework\v2.0.50727\Microsoft .NET Framework 2.0\install.exe"
;The expected file version.
$AppBinFileVersion = "8.0.50727.42"
;The installation source directory
$SourceDir = "\\server\share\applications patches\dotnet2.0\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

If $CurrentVer < $AppBinFileVersion Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;Download the files to a temp directory and start the setup.
	DirCreate ( $TMPDIR & "\" & $AppName )
	DirCopy ( $SourceDir, $TMPDIR & "\" & $AppName, 1 )
	Run ( $TMPDIR & "\" & $AppName & "\" & "dotnetfx.exe",@WindowsDir )
	
	WinWait("Microsoft .NET Framework 2.0 Setup","Welcome to Microsoft .NET")
	ControlClick("Microsoft .NET Framework 2.0 Setup","Welcome to Microsoft .NET","&Next >")
	
	WinWait("Microsoft .NET Framework 2.0 Setup","End-User License")
	ControlCommand("Microsoft .NET Framework 2.0 Setup","End-User License","Button11","Check","")
	Send("{TAB}{TAB}{ENTER}")
	;ControlClick("Microsoft .NET Framework 2.0 Setup","End-User License", "&Next >")
	
	WinWait("Microsoft .NET Framework 2.0 Setup","Setup Complete")
	Send("{TAB}{TAB}{TAB}{ENTER}")
	;ControlClick("Microsoft .NET Framework 2.0 Setup","Setup Complete","&Cancel")
	
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

