;===============================================================================
;
; Description:      .NET Framework 1.1 Installer
; Syntax:           DotNet1.1.au3
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Joshua Morris
; Note(s):          This script installs the .NET Framework 1.1 
; Last Modified:    5/7/09
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "DotNet1.1"
;The binary file whose version we will check.
$AppBinFile = "C:\WINDOWS\Microsoft.NET\Framework\v1.1.4322\InstallUtil.exe"
;The expected file version.
$AppBinFileVersion = "1.1.4322.573"
;The installation source directory
$SourceDir = "\\server\share\applications\dotnet1.1\"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)
	
	Run ($TMPDIR & "\" & $AppName & "\" & "dotnetfx.exe",@WindowsDir )
	
	WinWait("Microsoft .NET Framework 1.1 Setup","Would you like to install")
	ControlClick("Microsoft .NET Framework 1.1 Setup","Would you like to install","&Yes")
	
	WinWait("Microsoft .NET Framework 1.1 Setup","License Agreement")
	ControlCommand("Microsoft .NET Framework 1.1 Setup","License Agreement","Button3","Check","")
	ControlClick("Microsoft .NET Framework 1.1 Setup","License Agreement","&Install")
	
	WinWait("Microsoft .NET Framework 1.1 Setup","Installation of Microsoft .NET Framework")
	ControlClick("Microsoft .NET Framework 1.1 Setup","Installation of Microsoft .NET Framework","OK")

	;install .NET 1.1 SP1	
	Run($TMPDIR & "\" & $AppName & "\NDP1.1sp1-KB867460-X86.exe") 
	
	WinWait("Microsoft .NET Framework 1.1 Service Pack 1 (KB867460)","Do you want to install")
	ControlClick("Microsoft .NET Framework 1.1 Service Pack 1 (KB867460)","Do you want to install","OK")
	
	WinWait("Microsoft .NET Framework 1.1 Service Pack 1","Please read the rights")
	ControlClick("Microsoft .NET Framework 1.1 Service Pack 1","Please read the rights","I &accept")
	
	WinWait("Microsoft .NET Framework 1.1 Service Pack 1 (KB867460)","Microsoft .NET Framework 1.1 Service")
	ControlClick("Microsoft .NET Framework 1.1 Service Pack 1 (KB867460)","Microsoft .NET Framework 1.1 Service","OK")
	
	WinWait("Microsoft .NET Framework 1.1","You must restart")
	ControlClick("Microsoft .NET Framework 1.1","You must restart","&No")
		
	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

