;===============================================================================
;
; Description:      Acrobat Reader X Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Josh Morris
; Note(s):          This script installs Acrobat Reader
; Last Modified:    1/12/12
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "AdobeReader"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Adobe\Reader 10.0\Reader\AcroRd32.dll"
Else
	$AppBinFile = "C:\Program Files\Adobe\Reader 10.0\Reader\AcroRd32.dll"
EndIf

;The expected file version.
$AppBinFileVersion = "10.1.2.45"
;The installation source directory
$SourceDir = "\\server\share\applications\adobe reader x"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	Run ($TMPDIR & "\" & $AppName & "\" & "AdbeRdr1012_en_US.exe",@WindowsDir )

	WinWait("Adobe Reader X","")

	AdlibRegister  ( "CheckMultiVersion")

	WinWait("Adobe Reader","Setup Completed")
	ControlClick("Adobe Reader","Setup Completed","Launch Adobe Reader")
	ControlClick("Adobe Reader","Setup Completed","&Finish")

	Sleep(1500)
	
	AdlibUNRegister  ( )

	;Delete Acrobat.com shortcuts
	$counter = 0
	If @OSVersion == "WIN_VISTA" Then
		While Not FileExists("C:\Users\Public\Desktop\Acrobat.com.lnk") AND $counter < 30
			Sleep(1000)
			$counter = $counter + 1
		WEnd
		FileDelete("C:\Users\Public\Desktop\Acrobat.com.lnk")
		FileDelete("C:\ProgramData\Microsoft\Windows\Start Menu\Programs\Acrobat.com.lnk")
	Else
		While Not FileExists($ALLUSERSPROFILE & "\Desktop\Acrobat.com.lnk") AND $counter < 30
			Sleep(1000)
			$counter = $counter + 1
		WEnd
		FileDelete( $ALLUSERSPROFILE & "\Desktop\Acrobat.com.lnk" )
		FileDelete("C:\Documents and Settings\All Users\Start Menu\Programs\Acrobat.com.lnk")
	EndIf

	; uninstall Acrobat.com C:\Program Files\Common Files\Adobe AIR\Versions\1.0\Adobe AIR Application Installer.exe -uninstall com.adobe.mauby 4875E02D9FB21EE389F73B8D1702B320485DF8CE.1
	; win title - Installer, hit enter (x 297(268)-129 y 715-525)

	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

func CheckMultiVersion()
	If WinExists("Adobe Reader","Default application for viewing PDF") Then
		ControlClick("Adobe Reader","Default application for viewing PDF","&Next >")
	EndIf

	If WinExists("Adobe Reader","Destination Folder") Then
		ControlClick("Adobe Reader","Destination Folder","&Next >")
	EndIf

	if WinExists("Adobe Reader","Ready to Install Adobe Reader") Then
		ControlClick("Adobe Reader","Ready to Install Adobe Reader","&Install")
	EndIf
	
	if WinExists("Adobe Reader","Welcome to the Patch") Then
		ControlClick("Adobe Reader","Welcome to the Patch","&Update >")
	EndIf
	
	if WinExists("setup","Setup needs") Then
		ControlClick("setup","Setup needs","&No")
	EndIf

EndFunc
