;===============================================================================
;
; Description:      Acrobat Standard Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Josh Morris
; Note(s):          This script installs Acrobat Standard
;                   It includes our license key, so it should not be distributed
; Last Modified:    8/25/11
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Acrobat8"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Adobe\Acrobat 8.0\Acrobat\Acrobat.dll"
Else
	$AppBinFile = "C:\Program Files\Adobe\Acrobat 8.0\Acrobat\Acrobat.dll"
EndIf

;The expected file version.
$AppBinFileVersion = "8.3.0.280"
;The installation source directory
$SourceDir = "\\server\share\applications\acrobat 8"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	 AdlibRegister( "CheckMultiVersion")

	If ($CurrentVer < "8.1.0.137") Then
	;then no Acrobat installed, install Acrobat 8

		Run ($TMPDIR & "\" & $AppName & "\" & "setup.exe",@WindowsDir )

		WinWait("Adobe Acrobat","Splash")
		ControlClick("Adobe Acrobat","Splash","&Next >")

		WinWait("Adobe Acrobat","Customer Information")
		Send("Department of Political Science{TAB}")
		Send("The Ohio State University{TAB}")
		Send("xxxx-xxxx")
		Sleep(200)
		Send("-xxxx-xxxx")
		Sleep(200)
		Send("-xxxx-xxxx")
		Sleep(300)
		ControlClick("Adobe Acrobat","Customer Information","&Next >")

		WinWait("Adobe Acrobat","PDFMaker Installation")
		ControlClick("Adobe Acrobat","PDFMaker Installation","&Next >")

		WinWait("Adobe Acrobat","Setup Type")
		ControlClick("Adobe Acrobat","Setup Type","Co&mplete")
		ControlClick("Adobe Acrobat","Setup Type","&Next >")

		WinWait("Adobe Acrobat","Destination Folder")
		ControlClick("Adobe Acrobat","Destination Folder","&Next >")

		WinWait("Adobe Acrobat","Ready to Install")
		ControlClick("Adobe Acrobat","Ready to Install","&Update")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlCommand("Adobe Acrobat","Setup Completed","Button2","UnCheck","")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf

	If ($CurrentVer < "8.1.1.0") Then
		;Run 8.1.1 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd811_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf

	If ($CurrentVer < "8.1.2.0") Then
		;Run 8.1.2 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd812_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf

	If ($CurrentVer < "8.1.3.187") Then
		;Run 8.1.3 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd813_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf


	If ($CurrentVer < "8.1.6.21") Then
		;Run 8.1.6 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd816_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf

	If ($CurrentVer < "8.1.7.59" ) Then
		;Run 8.1.7 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd817_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf

	If ($CurrentVer < "8.2.0.81" ) Then
		;Run 8.2.0 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd820_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf

	If ($CurrentVer < "8.2.2.217" ) Then

		;Run 8.2.2 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd822_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf

	If ($CurrentVer < "8.2.3.231" ) Then

		;Run 8.2.3 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd823_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf

	If ($CurrentVer < "8.2.5.241" ) Then

		;Run 8.2.5 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd825_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf
	
	If ($CurrentVer < "8.2.6.262" ) Then

		;Run 8.2.6 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd826_all_incr.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")
	EndIf
	
	;Run 8.3 patch
	Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd830_all_incr.msp")

	WinWait("Adobe Acrobat","Welcome to the Patch")
	ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

	WinWait("Adobe Acrobat","Setup Completed")
	ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	Sleep(1000)

	AdlibUnRegister ( )


	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

func CheckMultiVersion()
	If WinExists("Adobe Acrobat","Default application for viewing PDF") Then
		ControlClick("Adobe Acrobat","Default application for viewing PDF","&Next >")
	EndIf

	If WinExists("Adobe Acrobat","You must restart") Then
		ControlClick("Adobe Acrobat","You must restart","&No")
	EndIf
EndFunc
