;===============================================================================
;
; Description:      Acrobat Installer
; Parameter(s):     none
; Requirement(s):   AutoIT
; Return Value(s):  Logfile
; Author(s):        Josh Morris
; Note(s):          This script installs Acrobat Pro
;                   It includes our license key, so it should not be distributed
; Last Modified:    10/2/12
;
;===============================================================================

#include "include\file.au3"
#include "include\mousefix.au3"
#include "include\versioncompare.au3"
#include "include\filecopyprogress.au3"

;in case UAC is on
#requireadmin

AutoItSetOption("TrayIconDebug",1)

$TMPDIR = EnvGet ( "TEMP")
$ALLUSERSPROFILE = EnvGet ( "ALLUSERSPROFILE")
$PATH = EnvGet ("PATH")
$LogFile = $TMPDIR & "\wksAutoITscript_logfile.txt"

$AppName = "Acrobat10"
;The binary file whose version we will check.
If @OSArch == "X64" Then
	$AppBinFile = "C:\Program Files (x86)\Adobe\Acrobat 10.0\Acrobat\Acrobat.dll"
Else
	$AppBinFile = "C:\Program Files\Adobe\Acrobat 10.0\Acrobat\Acrobat.dll"
EndIf

;The expected file version.
$AppBinFileVersion = "10.1.4.38"
;The installation source directory
$SourceDir = "\\server\share\applications\acrobat x"

;Check for the existence of the correct version.
_FileWriteLog($LogFile, "Now checking for " & $AppName & "...")
$CurrentVer = FileGetVersion ( $AppBinFile )
_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)

if Call("VersionStringCompare",$CurrentVer,$AppBinFileVersion) Then

	_FileWriteLog($LogFile, $AppName & " needs to be installed or upgraded.")
	_FileWriteLog($LogFile, "Launching Setup now...")

	;download installation files with progress bar
	_DownloadWithProgress($SourceDir, $TMPDIR, $AppName)

	AdlibRegister( "CheckMultiVersion")

	If ($CurrentVer < "10.0.0.396") Then
	;then no Acrobat installed, install Acrobat 10

		Run ($TMPDIR & "\" & $AppName & "\" & "setup.exe",@WindowsDir )
		
		WinWait("Adobe Acrobat","Splash")
		ControlClick("Adobe Acrobat","Splash","&Next >")
		
		Sleep(500)

		WinWait("Adobe Acrobat","The following information")
		Send("{TAB}") ;get to serial number box
		Send("xxxx-xxxx-")
		Sleep(300)
		Send("xxxx-xxxx-")
 		Sleep(300)
		Send("xxxx-xxxx")
		Sleep(300)
		Send("{TAB}{TAB}{TAB}{TAB}") ;get to name box
		Send("User{TAB}")
		Send("Organization{TAB}")
		
		ControlClick("Adobe Acrobat","The following information","&Next >")

		WinWait("Adobe Acrobat","Setup Type")
		ControlClick("Adobe Acrobat","Setup Type","Co&mplete")
		ControlClick("Adobe Acrobat","Setup Type","&Next >")

		WinWait("Adobe Acrobat","Destination Folder")
		ControlClick("Adobe Acrobat","Destination Folder","&Next >")

		WinWait("Adobe Acrobat","Ready to Install")
		ControlClick("Adobe Acrobat","Ready to Install","&Install")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlCommand("Adobe Acrobat","Setup Completed","Button2","UnCheck","")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf

	If ($CurrentVer < "10.1.0.534") Then
		;Run 10.1 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd1010.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf
	
	If ($CurrentVer < "10.1.1.0") Then
		;Run 10.1.1	patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd1011.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		Sleep(100)
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf
	
	If ($CurrentVer < "10.1.2.45") Then
		;Run 10.1.2 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd1012.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		Sleep(100)
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf
	
	If ($CurrentVer < "10.1.3.23") Then
		;Run 10.1.3 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd1013.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")

		WinWait("Adobe Acrobat","Setup Completed")
		Sleep(100)
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf
	
	If ($CurrentVer < "10.1.4.23") Then
		;Run 10.1.3 patch
		Run ("msiexec /update " & $TMPDIR & "\" & $AppName & "\" & "AcrobatUpd1014.msp")

		WinWait("Adobe Acrobat","Welcome to the Patch")
		ControlClick("Adobe Acrobat","Welcome to the Patch","&Update >")
		
		WinWait("Adobe Acrobat","Setup Completed")
		Sleep(100)
		ControlClick("Adobe Acrobat","Setup Completed","&Finish")

	EndIf
	
	Sleep(1000)

	AdlibUnRegister ()


	;Re-check the version after install.
	$CurrentVer = FileGetVersion ( $AppBinFile )
	_FileWriteLog($LogFile, "The current version is: " & $CurrentVer)
	_FileWriteLog($LogFile, $AppName & " setup is now finished.")

Else
	;The correct version must be installed.
	_FileWriteLog($LogFile, $AppName & " is the correct version. Nothing to install.")
EndIf

func CheckMultiVersion()
	If WinExists("Adobe Acrobat","Default PDF Viewer") Then
		ControlClick("Adobe Acrobat","Default PDF Viewer","&Next >")
	EndIf
	
	If WinExists("Setup","Select the language") Then
		ControlClick("Setup","Select the language","OK")
	EndIf

	If WinExists("Adobe Acrobat","You must restart") Then
		ControlClick("Adobe Acrobat","You must restart","&No")
	EndIf
EndFunc
